package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.{
  AddressBookDescription,
  AddressBookName,
  Arn
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AddressBookData(
    addressBookArn: Option[Arn] = None,
    name: Option[AddressBookName] = None,
    description: Option[AddressBookDescription] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.AddressBookData = {
    import AddressBookData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.AddressBookData
      .builder()
      .optionallyWith(
        addressBookArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.addressBookArn)
      .optionallyWith(
        name.map(value => AddressBookName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          AddressBookDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.AddressBookData.ReadOnly =
    zio.aws.alexaforbusiness.model.AddressBookData.wrap(buildAwsValue())
}
object AddressBookData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.AddressBookData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.AddressBookData =
      zio.aws.alexaforbusiness.model.AddressBookData(
        addressBookArn.map(value => value),
        name.map(value => value),
        description.map(value => value)
      )
    def addressBookArn: Option[Arn]
    def name: Option[AddressBookName]
    def description: Option[AddressBookDescription]
    def getAddressBookArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("addressBookArn", addressBookArn)
    def getName: ZIO[Any, AwsError, AddressBookName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, AddressBookDescription] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.AddressBookData
  ) extends zio.aws.alexaforbusiness.model.AddressBookData.ReadOnly {
    override val addressBookArn: Option[Arn] = scala
      .Option(impl.addressBookArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
    override val name: Option[AddressBookName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.AddressBookName(value)
      )
    override val description: Option[AddressBookDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.AddressBookDescription(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.AddressBookData
  ): zio.aws.alexaforbusiness.model.AddressBookData.ReadOnly = new Wrapper(impl)
}
