package zio.aws.alexaforbusiness.model
import scala.jdk.CollectionConverters._
sealed trait Locale {
  def unwrap: software.amazon.awssdk.services.alexaforbusiness.model.Locale
}
object Locale {
  def wrap(
      value: software.amazon.awssdk.services.alexaforbusiness.model.Locale
  ): zio.aws.alexaforbusiness.model.Locale = value match {
    case software.amazon.awssdk.services.alexaforbusiness.model.Locale.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.Locale.EN_US =>
      val r = `en-US`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.alexaforbusiness.model.Locale {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.Locale =
      software.amazon.awssdk.services.alexaforbusiness.model.Locale.UNKNOWN_TO_SDK_VERSION
  }
  case object `en-US` extends zio.aws.alexaforbusiness.model.Locale {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.Locale =
      software.amazon.awssdk.services.alexaforbusiness.model.Locale.EN_US
  }
}
