package zio.aws.alexaforbusiness
import zio.aws.alexaforbusiness.model.SendAnnouncementRequest
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import software.amazon.awssdk.services.alexaforbusiness.AlexaForBusinessAsyncClient
import zio.aws.alexaforbusiness.model.SendAnnouncementResponse.ReadOnly
object AlexaForBusinessMock extends Mock[AlexaForBusiness] {
  object SendAnnouncement
      extends Effect[SendAnnouncementRequest, AwsError, ReadOnly]
  val compose: URLayer[Proxy, AlexaForBusiness] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, AlexaForBusiness] { rts =>
        zio.ZIO.succeed {
          new AlexaForBusiness {
            val api: AlexaForBusinessAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): AlexaForBusiness = this
            def sendAnnouncement(
                request: SendAnnouncementRequest
            ): IO[AwsError, ReadOnly] = proxy(SendAnnouncement, request)
          }
        }
      }
    }
  }
}
