package zio.aws.alexaforbusiness
import zio.aws.alexaforbusiness.model.SendAnnouncementRequest
import software.amazon.awssdk.services.alexaforbusiness.model.SendAnnouncementResponse
import zio.aws.core.config.AwsConfig
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.alexaforbusiness.{
  AlexaForBusinessAsyncClientBuilder,
  AlexaForBusinessAsyncClient
}
import zio.aws.alexaforbusiness.model.SendAnnouncementResponse.ReadOnly
import scala.jdk.CollectionConverters._
trait AlexaForBusiness extends AspectSupport[AlexaForBusiness] {
  val api: AlexaForBusinessAsyncClient
  def sendAnnouncement(request: SendAnnouncementRequest): IO[AwsError, ReadOnly]
}
object AlexaForBusiness {
  val live: ZLayer[AwsConfig, java.lang.Throwable, AlexaForBusiness] =
    customized(identity)
  def customized(
      customization: AlexaForBusinessAsyncClientBuilder => AlexaForBusinessAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, AlexaForBusiness] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: AlexaForBusinessAsyncClientBuilder => AlexaForBusinessAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, AlexaForBusiness] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = AlexaForBusinessAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[
      AlexaForBusinessAsyncClient,
      AlexaForBusinessAsyncClientBuilder
    ](builder);
    b1 <- awsConfig.configureHttpClient[
      AlexaForBusinessAsyncClient,
      AlexaForBusinessAsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new AlexaForBusinessImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class AlexaForBusinessImpl[R](
      override val api: AlexaForBusinessAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends AlexaForBusiness
      with AwsServiceBase[R] {
    override val serviceName: String = "AlexaForBusiness"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): AlexaForBusinessImpl[R1] = new AlexaForBusinessImpl(api, newAspect, r)
    def sendAnnouncement(
        request: SendAnnouncementRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.alexaforbusiness.model.SendAnnouncementRequest,
      SendAnnouncementResponse
    ]("sendAnnouncement", api.sendAnnouncement)(request.buildAwsValue())
      .map(zio.aws.alexaforbusiness.model.SendAnnouncementResponse.wrap)
      .provideEnvironment(r)
  }
  def sendAnnouncement(
      request: SendAnnouncementRequest
  ): ZIO[zio.aws.alexaforbusiness.AlexaForBusiness, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.sendAnnouncement(request))
}
