package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.Arn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetContactRequest(contactArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.GetContactRequest = {
    import GetContactRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.GetContactRequest
      .builder()
      .contactArn(Arn.unwrap(contactArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.GetContactRequest.ReadOnly =
    zio.aws.alexaforbusiness.model.GetContactRequest.wrap(buildAwsValue())
}
object GetContactRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.GetContactRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.GetContactRequest =
      zio.aws.alexaforbusiness.model.GetContactRequest(contactArn)
    def contactArn: Arn
    def getContactArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(contactArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.GetContactRequest
  ) extends zio.aws.alexaforbusiness.model.GetContactRequest.ReadOnly {
    override val contactArn: Arn =
      zio.aws.alexaforbusiness.model.primitives.Arn(impl.contactArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.GetContactRequest
  ): zio.aws.alexaforbusiness.model.GetContactRequest.ReadOnly = new Wrapper(
    impl
  )
}
