package zio.aws.alexaforbusiness.model
import scala.jdk.CollectionConverters._
sealed trait EnrollmentStatus {
  def unwrap
      : software.amazon.awssdk.services.alexaforbusiness.model.EnrollmentStatus
}
object EnrollmentStatus {
  def wrap(
      value: software.amazon.awssdk.services.alexaforbusiness.model.EnrollmentStatus
  ): zio.aws.alexaforbusiness.model.EnrollmentStatus = value match {
    case software.amazon.awssdk.services.alexaforbusiness.model.EnrollmentStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.EnrollmentStatus.INITIALIZED =>
      val r = INITIALIZED
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.EnrollmentStatus.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.EnrollmentStatus.REGISTERED =>
      val r = REGISTERED
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.EnrollmentStatus.DISASSOCIATING =>
      val r = DISASSOCIATING
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.EnrollmentStatus.DEREGISTERING =>
      val r = DEREGISTERING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.alexaforbusiness.model.EnrollmentStatus {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.EnrollmentStatus =
      software.amazon.awssdk.services.alexaforbusiness.model.EnrollmentStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object INITIALIZED
      extends zio.aws.alexaforbusiness.model.EnrollmentStatus {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.EnrollmentStatus =
      software.amazon.awssdk.services.alexaforbusiness.model.EnrollmentStatus.INITIALIZED
  }
  case object PENDING extends zio.aws.alexaforbusiness.model.EnrollmentStatus {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.EnrollmentStatus =
      software.amazon.awssdk.services.alexaforbusiness.model.EnrollmentStatus.PENDING
  }
  case object REGISTERED
      extends zio.aws.alexaforbusiness.model.EnrollmentStatus {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.EnrollmentStatus =
      software.amazon.awssdk.services.alexaforbusiness.model.EnrollmentStatus.REGISTERED
  }
  case object DISASSOCIATING
      extends zio.aws.alexaforbusiness.model.EnrollmentStatus {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.EnrollmentStatus =
      software.amazon.awssdk.services.alexaforbusiness.model.EnrollmentStatus.DISASSOCIATING
  }
  case object DEREGISTERING
      extends zio.aws.alexaforbusiness.model.EnrollmentStatus {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.EnrollmentStatus =
      software.amazon.awssdk.services.alexaforbusiness.model.EnrollmentStatus.DEREGISTERING
  }
}
