package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.Arn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteDeviceUsageDataRequest(
    deviceArn: Arn,
    deviceUsageType: zio.aws.alexaforbusiness.model.DeviceUsageType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.DeleteDeviceUsageDataRequest = {
    import DeleteDeviceUsageDataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.DeleteDeviceUsageDataRequest
      .builder()
      .deviceArn(Arn.unwrap(deviceArn): java.lang.String)
      .deviceUsageType(deviceUsageType.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.DeleteDeviceUsageDataRequest.ReadOnly =
    zio.aws.alexaforbusiness.model.DeleteDeviceUsageDataRequest
      .wrap(buildAwsValue())
}
object DeleteDeviceUsageDataRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.DeleteDeviceUsageDataRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.alexaforbusiness.model.DeleteDeviceUsageDataRequest =
      zio.aws.alexaforbusiness.model
        .DeleteDeviceUsageDataRequest(deviceArn, deviceUsageType)
    def deviceArn: Arn
    def deviceUsageType: zio.aws.alexaforbusiness.model.DeviceUsageType
    def getDeviceArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(deviceArn)
    def getDeviceUsageType
        : ZIO[Any, Nothing, zio.aws.alexaforbusiness.model.DeviceUsageType] =
      ZIO.succeed(deviceUsageType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.DeleteDeviceUsageDataRequest
  ) extends zio.aws.alexaforbusiness.model.DeleteDeviceUsageDataRequest.ReadOnly {
    override val deviceArn: Arn =
      zio.aws.alexaforbusiness.model.primitives.Arn(impl.deviceArn())
    override val deviceUsageType
        : zio.aws.alexaforbusiness.model.DeviceUsageType =
      zio.aws.alexaforbusiness.model.DeviceUsageType
        .wrap(impl.deviceUsageType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.DeleteDeviceUsageDataRequest
  ): zio.aws.alexaforbusiness.model.DeleteDeviceUsageDataRequest.ReadOnly =
    new Wrapper(impl)
}
