package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.{
  SkillId,
  Email,
  OrganizationName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetInvitationConfigurationResponse(
    organizationName: Optional[OrganizationName] = Optional.Absent,
    contactEmail: Optional[Email] = Optional.Absent,
    privateSkillIds: Optional[Iterable[SkillId]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.GetInvitationConfigurationResponse = {
    import GetInvitationConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.GetInvitationConfigurationResponse
      .builder()
      .optionallyWith(
        organizationName.map(value =>
          OrganizationName.unwrap(value): java.lang.String
        )
      )(_.organizationName)
      .optionallyWith(
        contactEmail.map(value => Email.unwrap(value): java.lang.String)
      )(_.contactEmail)
      .optionallyWith(
        privateSkillIds.map(value =>
          value.map { item =>
            SkillId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.privateSkillIds)
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.GetInvitationConfigurationResponse.ReadOnly =
    zio.aws.alexaforbusiness.model.GetInvitationConfigurationResponse
      .wrap(buildAwsValue())
}
object GetInvitationConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.GetInvitationConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.alexaforbusiness.model.GetInvitationConfigurationResponse =
      zio.aws.alexaforbusiness.model.GetInvitationConfigurationResponse(
        organizationName.map(value => value),
        contactEmail.map(value => value),
        privateSkillIds.map(value => value)
      )
    def organizationName: Optional[OrganizationName]
    def contactEmail: Optional[Email]
    def privateSkillIds: Optional[List[SkillId]]
    def getOrganizationName: ZIO[Any, AwsError, OrganizationName] =
      AwsError.unwrapOptionField("organizationName", organizationName)
    def getContactEmail: ZIO[Any, AwsError, Email] =
      AwsError.unwrapOptionField("contactEmail", contactEmail)
    def getPrivateSkillIds: ZIO[Any, AwsError, List[SkillId]] =
      AwsError.unwrapOptionField("privateSkillIds", privateSkillIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.GetInvitationConfigurationResponse
  ) extends zio.aws.alexaforbusiness.model.GetInvitationConfigurationResponse.ReadOnly {
    override val organizationName: Optional[OrganizationName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.organizationName())
        .map(value =>
          zio.aws.alexaforbusiness.model.primitives.OrganizationName(value)
        )
    override val contactEmail: Optional[Email] = zio.aws.core.internal
      .optionalFromNullable(impl.contactEmail())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Email(value))
    override val privateSkillIds: Optional[List[SkillId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.privateSkillIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.alexaforbusiness.model.primitives.SkillId(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.GetInvitationConfigurationResponse
  ): zio.aws.alexaforbusiness.model.GetInvitationConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
