package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.{
  RawPhoneNumber,
  ContactName,
  Arn
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Contact(
    contactArn: Optional[Arn] = Optional.Absent,
    displayName: Optional[ContactName] = Optional.Absent,
    firstName: Optional[ContactName] = Optional.Absent,
    lastName: Optional[ContactName] = Optional.Absent,
    phoneNumber: Optional[RawPhoneNumber] = Optional.Absent,
    phoneNumbers: Optional[
      Iterable[zio.aws.alexaforbusiness.model.PhoneNumber]
    ] = Optional.Absent,
    sipAddresses: Optional[
      Iterable[zio.aws.alexaforbusiness.model.SipAddress]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.Contact = {
    import Contact.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.Contact
      .builder()
      .optionallyWith(
        contactArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.contactArn)
      .optionallyWith(
        displayName.map(value => ContactName.unwrap(value): java.lang.String)
      )(_.displayName)
      .optionallyWith(
        firstName.map(value => ContactName.unwrap(value): java.lang.String)
      )(_.firstName)
      .optionallyWith(
        lastName.map(value => ContactName.unwrap(value): java.lang.String)
      )(_.lastName)
      .optionallyWith(
        phoneNumber.map(value => RawPhoneNumber.unwrap(value): java.lang.String)
      )(_.phoneNumber)
      .optionallyWith(
        phoneNumbers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.phoneNumbers)
      .optionallyWith(
        sipAddresses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sipAddresses)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.Contact.ReadOnly =
    zio.aws.alexaforbusiness.model.Contact.wrap(buildAwsValue())
}
object Contact {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.Contact
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.Contact =
      zio.aws.alexaforbusiness.model.Contact(
        contactArn.map(value => value),
        displayName.map(value => value),
        firstName.map(value => value),
        lastName.map(value => value),
        phoneNumber.map(value => value),
        phoneNumbers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sipAddresses.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def contactArn: Optional[Arn]
    def displayName: Optional[ContactName]
    def firstName: Optional[ContactName]
    def lastName: Optional[ContactName]
    def phoneNumber: Optional[RawPhoneNumber]
    def phoneNumbers
        : Optional[List[zio.aws.alexaforbusiness.model.PhoneNumber.ReadOnly]]
    def sipAddresses
        : Optional[List[zio.aws.alexaforbusiness.model.SipAddress.ReadOnly]]
    def getContactArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("contactArn", contactArn)
    def getDisplayName: ZIO[Any, AwsError, ContactName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getFirstName: ZIO[Any, AwsError, ContactName] =
      AwsError.unwrapOptionField("firstName", firstName)
    def getLastName: ZIO[Any, AwsError, ContactName] =
      AwsError.unwrapOptionField("lastName", lastName)
    def getPhoneNumber: ZIO[Any, AwsError, RawPhoneNumber] =
      AwsError.unwrapOptionField("phoneNumber", phoneNumber)
    def getPhoneNumbers: ZIO[Any, AwsError, List[
      zio.aws.alexaforbusiness.model.PhoneNumber.ReadOnly
    ]] = AwsError.unwrapOptionField("phoneNumbers", phoneNumbers)
    def getSipAddresses: ZIO[Any, AwsError, List[
      zio.aws.alexaforbusiness.model.SipAddress.ReadOnly
    ]] = AwsError.unwrapOptionField("sipAddresses", sipAddresses)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.Contact
  ) extends zio.aws.alexaforbusiness.model.Contact.ReadOnly {
    override val contactArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.contactArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
    override val displayName: Optional[ContactName] = zio.aws.core.internal
      .optionalFromNullable(impl.displayName())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.ContactName(value)
      )
    override val firstName: Optional[ContactName] = zio.aws.core.internal
      .optionalFromNullable(impl.firstName())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.ContactName(value)
      )
    override val lastName: Optional[ContactName] = zio.aws.core.internal
      .optionalFromNullable(impl.lastName())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.ContactName(value)
      )
    override val phoneNumber: Optional[RawPhoneNumber] = zio.aws.core.internal
      .optionalFromNullable(impl.phoneNumber())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.RawPhoneNumber(value)
      )
    override val phoneNumbers
        : Optional[List[zio.aws.alexaforbusiness.model.PhoneNumber.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.phoneNumbers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.alexaforbusiness.model.PhoneNumber.wrap(item)
          }.toList
        )
    override val sipAddresses
        : Optional[List[zio.aws.alexaforbusiness.model.SipAddress.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sipAddresses())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.alexaforbusiness.model.SipAddress.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.Contact
  ): zio.aws.alexaforbusiness.model.Contact.ReadOnly = new Wrapper(impl)
}
