package zio.aws.alexaforbusiness.model
import scala.jdk.CollectionConverters._
sealed trait ConnectionStatus {
  def unwrap
      : software.amazon.awssdk.services.alexaforbusiness.model.ConnectionStatus
}
object ConnectionStatus {
  def wrap(
      value: software.amazon.awssdk.services.alexaforbusiness.model.ConnectionStatus
  ): zio.aws.alexaforbusiness.model.ConnectionStatus = value match {
    case software.amazon.awssdk.services.alexaforbusiness.model.ConnectionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.ConnectionStatus.ONLINE =>
      val r = ONLINE
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.ConnectionStatus.OFFLINE =>
      val r = OFFLINE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.alexaforbusiness.model.ConnectionStatus {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.ConnectionStatus =
      software.amazon.awssdk.services.alexaforbusiness.model.ConnectionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ONLINE extends zio.aws.alexaforbusiness.model.ConnectionStatus {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.ConnectionStatus =
      software.amazon.awssdk.services.alexaforbusiness.model.ConnectionStatus.ONLINE
  }
  case object OFFLINE extends zio.aws.alexaforbusiness.model.ConnectionStatus {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.ConnectionStatus =
      software.amazon.awssdk.services.alexaforbusiness.model.ConnectionStatus.OFFLINE
  }
}
