package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.{
  GatewayGroupDescription,
  GatewayGroupName,
  Arn
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateGatewayGroupRequest(
    gatewayGroupArn: Arn,
    name: Optional[GatewayGroupName] = Optional.Absent,
    description: Optional[GatewayGroupDescription] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.UpdateGatewayGroupRequest = {
    import UpdateGatewayGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.UpdateGatewayGroupRequest
      .builder()
      .gatewayGroupArn(Arn.unwrap(gatewayGroupArn): java.lang.String)
      .optionallyWith(
        name.map(value => GatewayGroupName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          GatewayGroupDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.UpdateGatewayGroupRequest.ReadOnly =
    zio.aws.alexaforbusiness.model.UpdateGatewayGroupRequest
      .wrap(buildAwsValue())
}
object UpdateGatewayGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.UpdateGatewayGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.UpdateGatewayGroupRequest =
      zio.aws.alexaforbusiness.model.UpdateGatewayGroupRequest(
        gatewayGroupArn,
        name.map(value => value),
        description.map(value => value)
      )
    def gatewayGroupArn: Arn
    def name: Optional[GatewayGroupName]
    def description: Optional[GatewayGroupDescription]
    def getGatewayGroupArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(gatewayGroupArn)
    def getName: ZIO[Any, AwsError, GatewayGroupName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, GatewayGroupDescription] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.UpdateGatewayGroupRequest
  ) extends zio.aws.alexaforbusiness.model.UpdateGatewayGroupRequest.ReadOnly {
    override val gatewayGroupArn: Arn =
      zio.aws.alexaforbusiness.model.primitives.Arn(impl.gatewayGroupArn())
    override val name: Optional[GatewayGroupName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.GatewayGroupName(value)
      )
    override val description: Optional[GatewayGroupDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.alexaforbusiness.model.primitives
            .GatewayGroupDescription(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.UpdateGatewayGroupRequest
  ): zio.aws.alexaforbusiness.model.UpdateGatewayGroupRequest.ReadOnly =
    new Wrapper(impl)
}
