package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.RawPhoneNumber
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class PhoneNumber(
    number: RawPhoneNumber,
    `type`: zio.aws.alexaforbusiness.model.PhoneNumberType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.PhoneNumber = {
    import PhoneNumber.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.PhoneNumber
      .builder()
      .number(RawPhoneNumber.unwrap(number): java.lang.String)
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.PhoneNumber.ReadOnly =
    zio.aws.alexaforbusiness.model.PhoneNumber.wrap(buildAwsValue())
}
object PhoneNumber {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.PhoneNumber
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.PhoneNumber =
      zio.aws.alexaforbusiness.model.PhoneNumber(number, `type`)
    def number: RawPhoneNumber
    def `type`: zio.aws.alexaforbusiness.model.PhoneNumberType
    def getNumber: ZIO[Any, Nothing, RawPhoneNumber] = ZIO.succeed(number)
    def getType
        : ZIO[Any, Nothing, zio.aws.alexaforbusiness.model.PhoneNumberType] =
      ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.PhoneNumber
  ) extends zio.aws.alexaforbusiness.model.PhoneNumber.ReadOnly {
    override val number: RawPhoneNumber =
      zio.aws.alexaforbusiness.model.primitives.RawPhoneNumber(impl.number())
    override val `type`: zio.aws.alexaforbusiness.model.PhoneNumberType =
      zio.aws.alexaforbusiness.model.PhoneNumberType.wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.PhoneNumber
  ): zio.aws.alexaforbusiness.model.PhoneNumber.ReadOnly = new Wrapper(impl)
}
