package zio.aws.alexaforbusiness.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.alexaforbusiness.model.primitives.{
  DeviceEventTime,
  DeviceEventValue
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DeviceEvent(
    `type`: Optional[zio.aws.alexaforbusiness.model.DeviceEventType] =
      Optional.Absent,
    value: Optional[DeviceEventValue] = Optional.Absent,
    timestamp: Optional[DeviceEventTime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.DeviceEvent = {
    import DeviceEvent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.DeviceEvent
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        value.map(value => DeviceEventValue.unwrap(value): java.lang.String)
      )(_.value)
      .optionallyWith(
        timestamp.map(value => DeviceEventTime.unwrap(value): Instant)
      )(_.timestamp)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.DeviceEvent.ReadOnly =
    zio.aws.alexaforbusiness.model.DeviceEvent.wrap(buildAwsValue())
}
object DeviceEvent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.DeviceEvent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.DeviceEvent =
      zio.aws.alexaforbusiness.model.DeviceEvent(
        `type`.map(value => value),
        value.map(value => value),
        timestamp.map(value => value)
      )
    def `type`: Optional[zio.aws.alexaforbusiness.model.DeviceEventType]
    def value: Optional[DeviceEventValue]
    def timestamp: Optional[DeviceEventTime]
    def getType
        : ZIO[Any, AwsError, zio.aws.alexaforbusiness.model.DeviceEventType] =
      AwsError.unwrapOptionField("type", `type`)
    def getValue: ZIO[Any, AwsError, DeviceEventValue] =
      AwsError.unwrapOptionField("value", value)
    def getTimestamp: ZIO[Any, AwsError, DeviceEventTime] =
      AwsError.unwrapOptionField("timestamp", timestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.DeviceEvent
  ) extends zio.aws.alexaforbusiness.model.DeviceEvent.ReadOnly {
    override val `type`
        : Optional[zio.aws.alexaforbusiness.model.DeviceEventType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value =>
          zio.aws.alexaforbusiness.model.DeviceEventType.wrap(value)
        )
    override val value: Optional[DeviceEventValue] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.DeviceEventValue(value)
      )
    override val timestamp: Optional[DeviceEventTime] = zio.aws.core.internal
      .optionalFromNullable(impl.timestamp())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.DeviceEventTime(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.DeviceEvent
  ): zio.aws.alexaforbusiness.model.DeviceEvent.ReadOnly = new Wrapper(impl)
}
