package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.SkillId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AssociateSkillWithUsersRequest(skillId: SkillId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.AssociateSkillWithUsersRequest = {
    import AssociateSkillWithUsersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.AssociateSkillWithUsersRequest
      .builder()
      .skillId(SkillId.unwrap(skillId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.AssociateSkillWithUsersRequest.ReadOnly =
    zio.aws.alexaforbusiness.model.AssociateSkillWithUsersRequest
      .wrap(buildAwsValue())
}
object AssociateSkillWithUsersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.AssociateSkillWithUsersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.alexaforbusiness.model.AssociateSkillWithUsersRequest =
      zio.aws.alexaforbusiness.model.AssociateSkillWithUsersRequest(skillId)
    def skillId: SkillId
    def getSkillId: ZIO[Any, Nothing, SkillId] = ZIO.succeed(skillId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.AssociateSkillWithUsersRequest
  ) extends zio.aws.alexaforbusiness.model.AssociateSkillWithUsersRequest.ReadOnly {
    override val skillId: SkillId =
      zio.aws.alexaforbusiness.model.primitives.SkillId(impl.skillId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.AssociateSkillWithUsersRequest
  ): zio.aws.alexaforbusiness.model.AssociateSkillWithUsersRequest.ReadOnly =
    new Wrapper(impl)
}
