package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.{TagKey, Arn}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UntagResourceRequest(arn: Arn, tagKeys: Iterable[TagKey]) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.UntagResourceRequest
      .builder()
      .arn(Arn.unwrap(arn): java.lang.String)
      .tagKeys(tagKeys.map { item =>
        TagKey.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.UntagResourceRequest.ReadOnly =
    zio.aws.alexaforbusiness.model.UntagResourceRequest.wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.UntagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.UntagResourceRequest =
      zio.aws.alexaforbusiness.model.UntagResourceRequest(arn, tagKeys)
    def arn: Arn
    def tagKeys: List[TagKey]
    def getArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(arn)
    def getTagKeys: ZIO[Any, Nothing, List[TagKey]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.UntagResourceRequest
  ) extends zio.aws.alexaforbusiness.model.UntagResourceRequest.ReadOnly {
    override val arn: Arn =
      zio.aws.alexaforbusiness.model.primitives.Arn(impl.arn())
    override val tagKeys: List[TagKey] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.alexaforbusiness.model.primitives.TagKey(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.UntagResourceRequest
  ): zio.aws.alexaforbusiness.model.UntagResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
