package zio.aws.alexaforbusiness.model
import scala.jdk.CollectionConverters._
sealed trait SkillTypeFilter {
  def unwrap
      : software.amazon.awssdk.services.alexaforbusiness.model.SkillTypeFilter
}
object SkillTypeFilter {
  def wrap(
      value: software.amazon.awssdk.services.alexaforbusiness.model.SkillTypeFilter
  ): zio.aws.alexaforbusiness.model.SkillTypeFilter = value match {
    case software.amazon.awssdk.services.alexaforbusiness.model.SkillTypeFilter.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.SkillTypeFilter.PUBLIC =>
      val r = PUBLIC
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.SkillTypeFilter.PRIVATE =>
      val r = PRIVATE
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.SkillTypeFilter.ALL =>
      val r = ALL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.alexaforbusiness.model.SkillTypeFilter {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.SkillTypeFilter =
      software.amazon.awssdk.services.alexaforbusiness.model.SkillTypeFilter.UNKNOWN_TO_SDK_VERSION
  }
  case object PUBLIC extends zio.aws.alexaforbusiness.model.SkillTypeFilter {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.SkillTypeFilter =
      software.amazon.awssdk.services.alexaforbusiness.model.SkillTypeFilter.PUBLIC
  }
  case object PRIVATE extends zio.aws.alexaforbusiness.model.SkillTypeFilter {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.SkillTypeFilter =
      software.amazon.awssdk.services.alexaforbusiness.model.SkillTypeFilter.PRIVATE
  }
  case object ALL extends zio.aws.alexaforbusiness.model.SkillTypeFilter {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.SkillTypeFilter =
      software.amazon.awssdk.services.alexaforbusiness.model.SkillTypeFilter.ALL
  }
}
