package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.Arn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetGatewayRequest(gatewayArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.GetGatewayRequest = {
    import GetGatewayRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.GetGatewayRequest
      .builder()
      .gatewayArn(Arn.unwrap(gatewayArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.GetGatewayRequest.ReadOnly =
    zio.aws.alexaforbusiness.model.GetGatewayRequest.wrap(buildAwsValue())
}
object GetGatewayRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.GetGatewayRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.GetGatewayRequest =
      zio.aws.alexaforbusiness.model.GetGatewayRequest(gatewayArn)
    def gatewayArn: Arn
    def getGatewayArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(gatewayArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.GetGatewayRequest
  ) extends zio.aws.alexaforbusiness.model.GetGatewayRequest.ReadOnly {
    override val gatewayArn: Arn =
      zio.aws.alexaforbusiness.model.primitives.Arn(impl.gatewayArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.GetGatewayRequest
  ): zio.aws.alexaforbusiness.model.GetGatewayRequest.ReadOnly = new Wrapper(
    impl
  )
}
