package zio.aws.alexaforbusiness.model
import scala.jdk.CollectionConverters._
sealed trait DistanceUnit {
  def unwrap
      : software.amazon.awssdk.services.alexaforbusiness.model.DistanceUnit
}
object DistanceUnit {
  def wrap(
      value: software.amazon.awssdk.services.alexaforbusiness.model.DistanceUnit
  ): zio.aws.alexaforbusiness.model.DistanceUnit = value match {
    case software.amazon.awssdk.services.alexaforbusiness.model.DistanceUnit.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.DistanceUnit.METRIC =>
      val r = METRIC
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.DistanceUnit.IMPERIAL =>
      val r = IMPERIAL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.alexaforbusiness.model.DistanceUnit {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.DistanceUnit =
      software.amazon.awssdk.services.alexaforbusiness.model.DistanceUnit.UNKNOWN_TO_SDK_VERSION
  }
  case object METRIC extends zio.aws.alexaforbusiness.model.DistanceUnit {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.DistanceUnit =
      software.amazon.awssdk.services.alexaforbusiness.model.DistanceUnit.METRIC
  }
  case object IMPERIAL extends zio.aws.alexaforbusiness.model.DistanceUnit {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.DistanceUnit =
      software.amazon.awssdk.services.alexaforbusiness.model.DistanceUnit.IMPERIAL
  }
}
