package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.Arn
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ConferencePreference(
    defaultConferenceProviderArn: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.ConferencePreference = {
    import ConferencePreference.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.ConferencePreference
      .builder()
      .optionallyWith(
        defaultConferenceProviderArn.map(value =>
          Arn.unwrap(value): java.lang.String
        )
      )(_.defaultConferenceProviderArn)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.ConferencePreference.ReadOnly =
    zio.aws.alexaforbusiness.model.ConferencePreference.wrap(buildAwsValue())
}
object ConferencePreference {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.ConferencePreference
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.ConferencePreference =
      zio.aws.alexaforbusiness.model
        .ConferencePreference(defaultConferenceProviderArn.map(value => value))
    def defaultConferenceProviderArn: Optional[Arn]
    def getDefaultConferenceProviderArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField(
        "defaultConferenceProviderArn",
        defaultConferenceProviderArn
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.ConferencePreference
  ) extends zio.aws.alexaforbusiness.model.ConferencePreference.ReadOnly {
    override val defaultConferenceProviderArn: Optional[Arn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultConferenceProviderArn())
        .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.ConferencePreference
  ): zio.aws.alexaforbusiness.model.ConferencePreference.ReadOnly = new Wrapper(
    impl
  )
}
