package zio.aws.alexaforbusiness.model
import scala.jdk.CollectionConverters._
sealed trait NetworkSecurityType {
  def unwrap: software.amazon.awssdk.services.alexaforbusiness.model.NetworkSecurityType
}
object NetworkSecurityType {
  def wrap(
      value: software.amazon.awssdk.services.alexaforbusiness.model.NetworkSecurityType
  ): zio.aws.alexaforbusiness.model.NetworkSecurityType = value match {
    case software.amazon.awssdk.services.alexaforbusiness.model.NetworkSecurityType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.NetworkSecurityType.OPEN =>
      val r = OPEN
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.NetworkSecurityType.WEP =>
      val r = WEP
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.NetworkSecurityType.WPA_PSK =>
      val r = WPA_PSK
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.NetworkSecurityType.WPA2_PSK =>
      val r = WPA2_PSK
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.NetworkSecurityType.WPA2_ENTERPRISE =>
      val r = WPA2_ENTERPRISE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.alexaforbusiness.model.NetworkSecurityType {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.NetworkSecurityType =
      software.amazon.awssdk.services.alexaforbusiness.model.NetworkSecurityType.UNKNOWN_TO_SDK_VERSION
  }
  case object OPEN extends zio.aws.alexaforbusiness.model.NetworkSecurityType {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.NetworkSecurityType =
      software.amazon.awssdk.services.alexaforbusiness.model.NetworkSecurityType.OPEN
  }
  case object WEP extends zio.aws.alexaforbusiness.model.NetworkSecurityType {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.NetworkSecurityType =
      software.amazon.awssdk.services.alexaforbusiness.model.NetworkSecurityType.WEP
  }
  case object WPA_PSK
      extends zio.aws.alexaforbusiness.model.NetworkSecurityType {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.NetworkSecurityType =
      software.amazon.awssdk.services.alexaforbusiness.model.NetworkSecurityType.WPA_PSK
  }
  case object WPA2_PSK
      extends zio.aws.alexaforbusiness.model.NetworkSecurityType {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.NetworkSecurityType =
      software.amazon.awssdk.services.alexaforbusiness.model.NetworkSecurityType.WPA2_PSK
  }
  case object WPA2_ENTERPRISE
      extends zio.aws.alexaforbusiness.model.NetworkSecurityType {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.NetworkSecurityType =
      software.amazon.awssdk.services.alexaforbusiness.model.NetworkSecurityType.WPA2_ENTERPRISE
  }
}
