package zio.aws.alexaforbusiness.model
import scala.jdk.CollectionConverters._
sealed trait CommsProtocol {
  def unwrap
      : software.amazon.awssdk.services.alexaforbusiness.model.CommsProtocol
}
object CommsProtocol {
  def wrap(
      value: software.amazon.awssdk.services.alexaforbusiness.model.CommsProtocol
  ): zio.aws.alexaforbusiness.model.CommsProtocol = value match {
    case software.amazon.awssdk.services.alexaforbusiness.model.CommsProtocol.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.CommsProtocol.SIP =>
      val r = SIP
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.CommsProtocol.SIPS =>
      val r = SIPS
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.CommsProtocol.H323 =>
      val r = H323
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.alexaforbusiness.model.CommsProtocol {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.CommsProtocol =
      software.amazon.awssdk.services.alexaforbusiness.model.CommsProtocol.UNKNOWN_TO_SDK_VERSION
  }
  case object SIP extends zio.aws.alexaforbusiness.model.CommsProtocol {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.CommsProtocol =
      software.amazon.awssdk.services.alexaforbusiness.model.CommsProtocol.SIP
  }
  case object SIPS extends zio.aws.alexaforbusiness.model.CommsProtocol {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.CommsProtocol =
      software.amazon.awssdk.services.alexaforbusiness.model.CommsProtocol.SIPS
  }
  case object H323 extends zio.aws.alexaforbusiness.model.CommsProtocol {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.CommsProtocol =
      software.amazon.awssdk.services.alexaforbusiness.model.CommsProtocol.H323
  }
}
