package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListSkillsStoreSkillsByCategoryResponse(
    skillsStoreSkills: Optional[
      Iterable[zio.aws.alexaforbusiness.model.SkillsStoreSkill]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsStoreSkillsByCategoryResponse = {
    import ListSkillsStoreSkillsByCategoryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsStoreSkillsByCategoryResponse
      .builder()
      .optionallyWith(
        skillsStoreSkills.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.skillsStoreSkills)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.ListSkillsStoreSkillsByCategoryResponse.ReadOnly =
    zio.aws.alexaforbusiness.model.ListSkillsStoreSkillsByCategoryResponse
      .wrap(buildAwsValue())
}
object ListSkillsStoreSkillsByCategoryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsStoreSkillsByCategoryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.alexaforbusiness.model.ListSkillsStoreSkillsByCategoryResponse =
      zio.aws.alexaforbusiness.model.ListSkillsStoreSkillsByCategoryResponse(
        skillsStoreSkills.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def skillsStoreSkills: Optional[
      List[zio.aws.alexaforbusiness.model.SkillsStoreSkill.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getSkillsStoreSkills: ZIO[Any, AwsError, List[
      zio.aws.alexaforbusiness.model.SkillsStoreSkill.ReadOnly
    ]] = AwsError.unwrapOptionField("skillsStoreSkills", skillsStoreSkills)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsStoreSkillsByCategoryResponse
  ) extends zio.aws.alexaforbusiness.model.ListSkillsStoreSkillsByCategoryResponse.ReadOnly {
    override val skillsStoreSkills: Optional[
      List[zio.aws.alexaforbusiness.model.SkillsStoreSkill.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.skillsStoreSkills())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.alexaforbusiness.model.SkillsStoreSkill.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.alexaforbusiness.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsStoreSkillsByCategoryResponse
  ): zio.aws.alexaforbusiness.model.ListSkillsStoreSkillsByCategoryResponse.ReadOnly =
    new Wrapper(impl)
}
