package zio.aws.alexaforbusiness.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.alexaforbusiness.model.primitives.{MaxResults, NextToken, Arn}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListDeviceEventsRequest(
    deviceArn: Arn,
    eventType: Optional[zio.aws.alexaforbusiness.model.DeviceEventType] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.ListDeviceEventsRequest = {
    import ListDeviceEventsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.ListDeviceEventsRequest
      .builder()
      .deviceArn(Arn.unwrap(deviceArn): java.lang.String)
      .optionallyWith(eventType.map(value => value.unwrap))(_.eventType)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.ListDeviceEventsRequest.ReadOnly =
    zio.aws.alexaforbusiness.model.ListDeviceEventsRequest.wrap(buildAwsValue())
}
object ListDeviceEventsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.ListDeviceEventsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.ListDeviceEventsRequest =
      zio.aws.alexaforbusiness.model.ListDeviceEventsRequest(
        deviceArn,
        eventType.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def deviceArn: Arn
    def eventType: Optional[zio.aws.alexaforbusiness.model.DeviceEventType]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getDeviceArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(deviceArn)
    def getEventType
        : ZIO[Any, AwsError, zio.aws.alexaforbusiness.model.DeviceEventType] =
      AwsError.unwrapOptionField("eventType", eventType)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.ListDeviceEventsRequest
  ) extends zio.aws.alexaforbusiness.model.ListDeviceEventsRequest.ReadOnly {
    override val deviceArn: Arn =
      zio.aws.alexaforbusiness.model.primitives.Arn(impl.deviceArn())
    override val eventType
        : Optional[zio.aws.alexaforbusiness.model.DeviceEventType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventType())
        .map(value =>
          zio.aws.alexaforbusiness.model.DeviceEventType.wrap(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.alexaforbusiness.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.alexaforbusiness.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.ListDeviceEventsRequest
  ): zio.aws.alexaforbusiness.model.ListDeviceEventsRequest.ReadOnly =
    new Wrapper(impl)
}
