package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListDeviceEventsResponse(
    deviceEvents: Optional[
      Iterable[zio.aws.alexaforbusiness.model.DeviceEvent]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.ListDeviceEventsResponse = {
    import ListDeviceEventsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.ListDeviceEventsResponse
      .builder()
      .optionallyWith(
        deviceEvents.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.deviceEvents)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.ListDeviceEventsResponse.ReadOnly =
    zio.aws.alexaforbusiness.model.ListDeviceEventsResponse
      .wrap(buildAwsValue())
}
object ListDeviceEventsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.ListDeviceEventsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.ListDeviceEventsResponse =
      zio.aws.alexaforbusiness.model.ListDeviceEventsResponse(
        deviceEvents.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def deviceEvents
        : Optional[List[zio.aws.alexaforbusiness.model.DeviceEvent.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getDeviceEvents: ZIO[Any, AwsError, List[
      zio.aws.alexaforbusiness.model.DeviceEvent.ReadOnly
    ]] = AwsError.unwrapOptionField("deviceEvents", deviceEvents)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.ListDeviceEventsResponse
  ) extends zio.aws.alexaforbusiness.model.ListDeviceEventsResponse.ReadOnly {
    override val deviceEvents
        : Optional[List[zio.aws.alexaforbusiness.model.DeviceEvent.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deviceEvents())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.alexaforbusiness.model.DeviceEvent.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.alexaforbusiness.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.ListDeviceEventsResponse
  ): zio.aws.alexaforbusiness.model.ListDeviceEventsResponse.ReadOnly =
    new Wrapper(impl)
}
