package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.{
  GatewayVersion,
  GatewayDescription,
  GatewayName,
  Arn
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GatewaySummary(
    arn: Optional[Arn] = Optional.Absent,
    name: Optional[GatewayName] = Optional.Absent,
    description: Optional[GatewayDescription] = Optional.Absent,
    gatewayGroupArn: Optional[Arn] = Optional.Absent,
    softwareVersion: Optional[GatewayVersion] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.GatewaySummary = {
    import GatewaySummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.GatewaySummary
      .builder()
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        name.map(value => GatewayName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          GatewayDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        gatewayGroupArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.gatewayGroupArn)
      .optionallyWith(
        softwareVersion.map(value =>
          GatewayVersion.unwrap(value): java.lang.String
        )
      )(_.softwareVersion)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.GatewaySummary.ReadOnly =
    zio.aws.alexaforbusiness.model.GatewaySummary.wrap(buildAwsValue())
}
object GatewaySummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.GatewaySummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.GatewaySummary =
      zio.aws.alexaforbusiness.model.GatewaySummary(
        arn.map(value => value),
        name.map(value => value),
        description.map(value => value),
        gatewayGroupArn.map(value => value),
        softwareVersion.map(value => value)
      )
    def arn: Optional[Arn]
    def name: Optional[GatewayName]
    def description: Optional[GatewayDescription]
    def gatewayGroupArn: Optional[Arn]
    def softwareVersion: Optional[GatewayVersion]
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, GatewayName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, GatewayDescription] =
      AwsError.unwrapOptionField("description", description)
    def getGatewayGroupArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("gatewayGroupArn", gatewayGroupArn)
    def getSoftwareVersion: ZIO[Any, AwsError, GatewayVersion] =
      AwsError.unwrapOptionField("softwareVersion", softwareVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.GatewaySummary
  ) extends zio.aws.alexaforbusiness.model.GatewaySummary.ReadOnly {
    override val arn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
    override val name: Optional[GatewayName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.GatewayName(value)
      )
    override val description: Optional[GatewayDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.alexaforbusiness.model.primitives.GatewayDescription(value)
        )
    override val gatewayGroupArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.gatewayGroupArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
    override val softwareVersion: Optional[GatewayVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.softwareVersion())
        .map(value =>
          zio.aws.alexaforbusiness.model.primitives.GatewayVersion(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.GatewaySummary
  ): zio.aws.alexaforbusiness.model.GatewaySummary.ReadOnly = new Wrapper(impl)
}
