package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.{
  GatewayGroupDescription,
  GatewayGroupName,
  Arn
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GatewayGroup(
    arn: Optional[Arn] = Optional.Absent,
    name: Optional[GatewayGroupName] = Optional.Absent,
    description: Optional[GatewayGroupDescription] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.GatewayGroup = {
    import GatewayGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.GatewayGroup
      .builder()
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        name.map(value => GatewayGroupName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          GatewayGroupDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.GatewayGroup.ReadOnly =
    zio.aws.alexaforbusiness.model.GatewayGroup.wrap(buildAwsValue())
}
object GatewayGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.GatewayGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.GatewayGroup =
      zio.aws.alexaforbusiness.model.GatewayGroup(
        arn.map(value => value),
        name.map(value => value),
        description.map(value => value)
      )
    def arn: Optional[Arn]
    def name: Optional[GatewayGroupName]
    def description: Optional[GatewayGroupDescription]
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, GatewayGroupName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, GatewayGroupDescription] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.GatewayGroup
  ) extends zio.aws.alexaforbusiness.model.GatewayGroup.ReadOnly {
    override val arn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
    override val name: Optional[GatewayGroupName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.GatewayGroupName(value)
      )
    override val description: Optional[GatewayGroupDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.alexaforbusiness.model.primitives
            .GatewayGroupDescription(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.GatewayGroup
  ): zio.aws.alexaforbusiness.model.GatewayGroup.ReadOnly = new Wrapper(impl)
}
