package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.Arn
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateProfileResponse(
    profileArn: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.CreateProfileResponse = {
    import CreateProfileResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.CreateProfileResponse
      .builder()
      .optionallyWith(
        profileArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.profileArn)
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.CreateProfileResponse.ReadOnly =
    zio.aws.alexaforbusiness.model.CreateProfileResponse.wrap(buildAwsValue())
}
object CreateProfileResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.CreateProfileResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.CreateProfileResponse =
      zio.aws.alexaforbusiness.model
        .CreateProfileResponse(profileArn.map(value => value))
    def profileArn: Optional[Arn]
    def getProfileArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("profileArn", profileArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.CreateProfileResponse
  ) extends zio.aws.alexaforbusiness.model.CreateProfileResponse.ReadOnly {
    override val profileArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.profileArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.CreateProfileResponse
  ): zio.aws.alexaforbusiness.model.CreateProfileResponse.ReadOnly =
    new Wrapper(impl)
}
