package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.Arn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetConferenceProviderRequest(conferenceProviderArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.GetConferenceProviderRequest = {
    import GetConferenceProviderRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.GetConferenceProviderRequest
      .builder()
      .conferenceProviderArn(
        Arn.unwrap(conferenceProviderArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.GetConferenceProviderRequest.ReadOnly =
    zio.aws.alexaforbusiness.model.GetConferenceProviderRequest
      .wrap(buildAwsValue())
}
object GetConferenceProviderRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.GetConferenceProviderRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.alexaforbusiness.model.GetConferenceProviderRequest =
      zio.aws.alexaforbusiness.model
        .GetConferenceProviderRequest(conferenceProviderArn)
    def conferenceProviderArn: Arn
    def getConferenceProviderArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(conferenceProviderArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.GetConferenceProviderRequest
  ) extends zio.aws.alexaforbusiness.model.GetConferenceProviderRequest.ReadOnly {
    override val conferenceProviderArn: Arn =
      zio.aws.alexaforbusiness.model.primitives
        .Arn(impl.conferenceProviderArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.GetConferenceProviderRequest
  ): zio.aws.alexaforbusiness.model.GetConferenceProviderRequest.ReadOnly =
    new Wrapper(impl)
}
