package zio.aws.alexaforbusiness.model
import scala.jdk.CollectionConverters._
sealed trait Feature {
  def unwrap: software.amazon.awssdk.services.alexaforbusiness.model.Feature
}
object Feature {
  def wrap(
      value: software.amazon.awssdk.services.alexaforbusiness.model.Feature
  ): zio.aws.alexaforbusiness.model.Feature = value match {
    case software.amazon.awssdk.services.alexaforbusiness.model.Feature.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.Feature.BLUETOOTH =>
      val r = BLUETOOTH
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.Feature.VOLUME =>
      val r = VOLUME
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.Feature.NOTIFICATIONS =>
      val r = NOTIFICATIONS
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.Feature.LISTS =>
      val r = LISTS
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.Feature.SKILLS =>
      val r = SKILLS
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.Feature.NETWORK_PROFILE =>
      val r = NETWORK_PROFILE
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.Feature.SETTINGS =>
      val r = SETTINGS
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.Feature.ALL =>
      val r = ALL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.alexaforbusiness.model.Feature {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.Feature =
      software.amazon.awssdk.services.alexaforbusiness.model.Feature.UNKNOWN_TO_SDK_VERSION
  }
  case object BLUETOOTH extends zio.aws.alexaforbusiness.model.Feature {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.Feature =
      software.amazon.awssdk.services.alexaforbusiness.model.Feature.BLUETOOTH
  }
  case object VOLUME extends zio.aws.alexaforbusiness.model.Feature {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.Feature =
      software.amazon.awssdk.services.alexaforbusiness.model.Feature.VOLUME
  }
  case object NOTIFICATIONS extends zio.aws.alexaforbusiness.model.Feature {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.Feature =
      software.amazon.awssdk.services.alexaforbusiness.model.Feature.NOTIFICATIONS
  }
  case object LISTS extends zio.aws.alexaforbusiness.model.Feature {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.Feature =
      software.amazon.awssdk.services.alexaforbusiness.model.Feature.LISTS
  }
  case object SKILLS extends zio.aws.alexaforbusiness.model.Feature {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.Feature =
      software.amazon.awssdk.services.alexaforbusiness.model.Feature.SKILLS
  }
  case object NETWORK_PROFILE extends zio.aws.alexaforbusiness.model.Feature {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.Feature =
      software.amazon.awssdk.services.alexaforbusiness.model.Feature.NETWORK_PROFILE
  }
  case object SETTINGS extends zio.aws.alexaforbusiness.model.Feature {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.Feature =
      software.amazon.awssdk.services.alexaforbusiness.model.Feature.SETTINGS
  }
  case object ALL extends zio.aws.alexaforbusiness.model.Feature {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.Feature =
      software.amazon.awssdk.services.alexaforbusiness.model.Feature.ALL
  }
}
