package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.Arn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteContactRequest(contactArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.DeleteContactRequest = {
    import DeleteContactRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.DeleteContactRequest
      .builder()
      .contactArn(Arn.unwrap(contactArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.DeleteContactRequest.ReadOnly =
    zio.aws.alexaforbusiness.model.DeleteContactRequest.wrap(buildAwsValue())
}
object DeleteContactRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.DeleteContactRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.DeleteContactRequest =
      zio.aws.alexaforbusiness.model.DeleteContactRequest(contactArn)
    def contactArn: Arn
    def getContactArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(contactArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.DeleteContactRequest
  ) extends zio.aws.alexaforbusiness.model.DeleteContactRequest.ReadOnly {
    override val contactArn: Arn =
      zio.aws.alexaforbusiness.model.primitives.Arn(impl.contactArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.DeleteContactRequest
  ): zio.aws.alexaforbusiness.model.DeleteContactRequest.ReadOnly = new Wrapper(
    impl
  )
}
