package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.{
  ClientRequestToken,
  GatewayGroupDescription,
  GatewayGroupName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateGatewayGroupRequest(
    name: GatewayGroupName,
    description: Optional[GatewayGroupDescription] = Optional.Absent,
    clientRequestToken: ClientRequestToken,
    tags: Optional[Iterable[zio.aws.alexaforbusiness.model.Tag]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.CreateGatewayGroupRequest = {
    import CreateGatewayGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.CreateGatewayGroupRequest
      .builder()
      .name(GatewayGroupName.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value =>
          GatewayGroupDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .clientRequestToken(
        ClientRequestToken.unwrap(clientRequestToken): java.lang.String
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.CreateGatewayGroupRequest.ReadOnly =
    zio.aws.alexaforbusiness.model.CreateGatewayGroupRequest
      .wrap(buildAwsValue())
}
object CreateGatewayGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.CreateGatewayGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.CreateGatewayGroupRequest =
      zio.aws.alexaforbusiness.model.CreateGatewayGroupRequest(
        name,
        description.map(value => value),
        clientRequestToken,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: GatewayGroupName
    def description: Optional[GatewayGroupDescription]
    def clientRequestToken: ClientRequestToken
    def tags: Optional[List[zio.aws.alexaforbusiness.model.Tag.ReadOnly]]
    def getName: ZIO[Any, Nothing, GatewayGroupName] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, GatewayGroupDescription] =
      AwsError.unwrapOptionField("description", description)
    def getClientRequestToken: ZIO[Any, Nothing, ClientRequestToken] =
      ZIO.succeed(clientRequestToken)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.alexaforbusiness.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.CreateGatewayGroupRequest
  ) extends zio.aws.alexaforbusiness.model.CreateGatewayGroupRequest.ReadOnly {
    override val name: GatewayGroupName =
      zio.aws.alexaforbusiness.model.primitives.GatewayGroupName(impl.name())
    override val description: Optional[GatewayGroupDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.alexaforbusiness.model.primitives
            .GatewayGroupDescription(value)
        )
    override val clientRequestToken: ClientRequestToken =
      zio.aws.alexaforbusiness.model.primitives
        .ClientRequestToken(impl.clientRequestToken())
    override val tags
        : Optional[List[zio.aws.alexaforbusiness.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.alexaforbusiness.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.CreateGatewayGroupRequest
  ): zio.aws.alexaforbusiness.model.CreateGatewayGroupRequest.ReadOnly =
    new Wrapper(impl)
}
