package zio.aws.alexaforbusiness
import zio.aws.alexaforbusiness.model.DisassociateDeviceFromRoomResponse.ReadOnly
import zio.aws.alexaforbusiness.model.{
  DeleteUserRequest,
  StartSmartHomeApplianceDiscoveryRequest,
  UpdateProfileRequest,
  GetProfileRequest,
  UpdateBusinessReportScheduleRequest,
  SearchDevicesRequest,
  DisassociateSkillFromUsersRequest,
  CreateContactRequest,
  DeleteSkillGroupRequest,
  ListBusinessReportSchedulesRequest,
  ListTagsRequest,
  DeleteContactRequest,
  ListSkillsStoreSkillsByCategoryRequest,
  AssociateSkillWithSkillGroupRequest,
  DeleteRoomSkillParameterRequest,
  ForgetSmartHomeAppliancesRequest,
  ApproveSkillRequest,
  GetContactRequest,
  SearchProfilesRequest,
  SearchNetworkProfilesRequest,
  GetDeviceRequest,
  DeleteNetworkProfileRequest,
  DisassociateDeviceFromRoomRequest,
  GetInvitationConfigurationRequest,
  UpdateGatewayRequest,
  DisassociateSkillGroupFromRoomRequest,
  GetConferencePreferenceRequest,
  CreateProfileRequest,
  ListDeviceEventsRequest,
  AssociateSkillWithUsersRequest,
  SearchSkillGroupsRequest,
  RevokeInvitationRequest,
  UpdateNetworkProfileRequest,
  DeleteRoomRequest,
  DisassociateContactFromAddressBookRequest,
  GetNetworkProfileRequest,
  UpdateGatewayGroupRequest,
  UpdateConferenceProviderRequest,
  CreateRoomRequest,
  GetAddressBookRequest,
  SearchUsersRequest,
  DeleteProfileRequest,
  ListConferenceProvidersRequest,
  CreateUserRequest,
  UpdateAddressBookRequest,
  PutInvitationConfigurationRequest,
  SendInvitationRequest,
  DisassociateSkillFromSkillGroupRequest,
  CreateAddressBookRequest,
  GetRoomSkillParameterRequest,
  GetGatewayRequest,
  ListSkillsRequest,
  GetSkillGroupRequest,
  PutRoomSkillParameterRequest,
  SendAnnouncementRequest,
  AssociateSkillGroupWithRoomRequest,
  GetGatewayGroupRequest,
  SearchContactsRequest,
  DeleteGatewayGroupRequest,
  UntagResourceRequest,
  ListSkillsStoreCategoriesRequest,
  DeleteBusinessReportScheduleRequest,
  DeleteConferenceProviderRequest,
  SearchRoomsRequest,
  DeleteAddressBookRequest,
  DeleteDeviceUsageDataRequest,
  DeleteSkillAuthorizationRequest,
  RejectSkillRequest,
  ResolveRoomRequest,
  UpdateRoomRequest,
  UpdateDeviceRequest,
  UpdateSkillGroupRequest,
  ListSmartHomeAppliancesRequest,
  CreateGatewayGroupRequest,
  PutConferencePreferenceRequest,
  CreateNetworkProfileRequest,
  StartDeviceSyncRequest,
  ListGatewaysRequest,
  CreateConferenceProviderRequest,
  CreateSkillGroupRequest,
  DeleteDeviceRequest,
  AssociateContactWithAddressBookRequest,
  GetConferenceProviderRequest,
  UpdateContactRequest,
  CreateBusinessReportScheduleRequest,
  GetRoomRequest,
  ListGatewayGroupsRequest,
  TagResourceRequest,
  AssociateDeviceWithRoomRequest,
  SearchAddressBooksRequest,
  PutSkillAuthorizationRequest,
  AssociateDeviceWithNetworkProfileRequest,
  RegisterAvsDeviceRequest
}
import zio.mock.{Proxy, Mock}
import zio.aws.core.{StreamingOutputResult, AwsError}
import zio.aws.core.aspects.AwsCallAspect
import zio.{ZIO, IO, ZEnvironment, URLayer}
import software.amazon.awssdk.services.alexaforbusiness.AlexaForBusinessAsyncClient
import zio.stream.ZStream
object AlexaForBusinessMock extends Mock[AlexaForBusiness] {
  object UpdateContact
      extends Effect[
        UpdateContactRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.UpdateContactResponse.ReadOnly
      ]
  object DeleteRoomSkillParameter
      extends Effect[
        DeleteRoomSkillParameterRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.DeleteRoomSkillParameterResponse.ReadOnly
      ]
  object AssociateSkillWithUsers
      extends Effect[
        AssociateSkillWithUsersRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.AssociateSkillWithUsersResponse.ReadOnly
      ]
  object DeleteSkillAuthorization
      extends Effect[
        DeleteSkillAuthorizationRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.DeleteSkillAuthorizationResponse.ReadOnly
      ]
  object DeleteConferenceProvider
      extends Effect[
        DeleteConferenceProviderRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.DeleteConferenceProviderResponse.ReadOnly
      ]
  object UpdateGateway
      extends Effect[
        UpdateGatewayRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.UpdateGatewayResponse.ReadOnly
      ]
  object UpdateGatewayGroup
      extends Effect[
        UpdateGatewayGroupRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.UpdateGatewayGroupResponse.ReadOnly
      ]
  object SearchUsers
      extends Effect[SearchUsersRequest, AwsError, StreamingOutputResult[
        Any,
        zio.aws.alexaforbusiness.model.SearchUsersResponse.ReadOnly,
        zio.aws.alexaforbusiness.model.UserData.ReadOnly
      ]]
  object SearchUsersPaginated
      extends Effect[
        SearchUsersRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.SearchUsersResponse.ReadOnly
      ]
  object SearchSkillGroups
      extends Effect[SearchSkillGroupsRequest, AwsError, StreamingOutputResult[
        Any,
        zio.aws.alexaforbusiness.model.SearchSkillGroupsResponse.ReadOnly,
        zio.aws.alexaforbusiness.model.SkillGroupData.ReadOnly
      ]]
  object SearchSkillGroupsPaginated
      extends Effect[
        SearchSkillGroupsRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.SearchSkillGroupsResponse.ReadOnly
      ]
  object AssociateSkillWithSkillGroup
      extends Effect[
        AssociateSkillWithSkillGroupRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.AssociateSkillWithSkillGroupResponse.ReadOnly
      ]
  object RevokeInvitation
      extends Effect[
        RevokeInvitationRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.RevokeInvitationResponse.ReadOnly
      ]
  object ListSkillsStoreCategories
      extends Stream[
        ListSkillsStoreCategoriesRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.Category.ReadOnly
      ]
  object ListSkillsStoreCategoriesPaginated
      extends Effect[
        ListSkillsStoreCategoriesRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.ListSkillsStoreCategoriesResponse.ReadOnly
      ]
  object DisassociateSkillFromSkillGroup
      extends Effect[
        DisassociateSkillFromSkillGroupRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.DisassociateSkillFromSkillGroupResponse.ReadOnly
      ]
  object GetRoomSkillParameter
      extends Effect[
        GetRoomSkillParameterRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.GetRoomSkillParameterResponse.ReadOnly
      ]
  object UpdateNetworkProfile
      extends Effect[
        UpdateNetworkProfileRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.UpdateNetworkProfileResponse.ReadOnly
      ]
  object AssociateContactWithAddressBook
      extends Effect[
        AssociateContactWithAddressBookRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.AssociateContactWithAddressBookResponse.ReadOnly
      ]
  object ListConferenceProviders
      extends Stream[
        ListConferenceProvidersRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.ConferenceProvider.ReadOnly
      ]
  object ListConferenceProvidersPaginated
      extends Effect[
        ListConferenceProvidersRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.ListConferenceProvidersResponse.ReadOnly
      ]
  object ListSkillsStoreSkillsByCategory
      extends Stream[
        ListSkillsStoreSkillsByCategoryRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.SkillsStoreSkill.ReadOnly
      ]
  object ListSkillsStoreSkillsByCategoryPaginated
      extends Effect[
        ListSkillsStoreSkillsByCategoryRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.ListSkillsStoreSkillsByCategoryResponse.ReadOnly
      ]
  object ListTags
      extends Stream[
        ListTagsRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.Tag.ReadOnly
      ]
  object ListTagsPaginated
      extends Effect[
        ListTagsRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.ListTagsResponse.ReadOnly
      ]
  object DeleteAddressBook
      extends Effect[
        DeleteAddressBookRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.DeleteAddressBookResponse.ReadOnly
      ]
  object CreateConferenceProvider
      extends Effect[
        CreateConferenceProviderRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.CreateConferenceProviderResponse.ReadOnly
      ]
  object DeleteDevice
      extends Effect[
        DeleteDeviceRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.DeleteDeviceResponse.ReadOnly
      ]
  object CreateGatewayGroup
      extends Effect[
        CreateGatewayGroupRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.CreateGatewayGroupResponse.ReadOnly
      ]
  object GetGatewayGroup
      extends Effect[
        GetGatewayGroupRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.GetGatewayGroupResponse.ReadOnly
      ]
  object UpdateRoom
      extends Effect[
        UpdateRoomRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.UpdateRoomResponse.ReadOnly
      ]
  object DeleteContact
      extends Effect[
        DeleteContactRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.DeleteContactResponse.ReadOnly
      ]
  object UpdateBusinessReportSchedule
      extends Effect[
        UpdateBusinessReportScheduleRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.UpdateBusinessReportScheduleResponse.ReadOnly
      ]
  object AssociateDeviceWithNetworkProfile
      extends Effect[
        AssociateDeviceWithNetworkProfileRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.AssociateDeviceWithNetworkProfileResponse.ReadOnly
      ]
  object CreateContact
      extends Effect[
        CreateContactRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.CreateContactResponse.ReadOnly
      ]
  object PutSkillAuthorization
      extends Effect[
        PutSkillAuthorizationRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.PutSkillAuthorizationResponse.ReadOnly
      ]
  object CreateAddressBook
      extends Effect[
        CreateAddressBookRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.CreateAddressBookResponse.ReadOnly
      ]
  object UpdateConferenceProvider
      extends Effect[
        UpdateConferenceProviderRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.UpdateConferenceProviderResponse.ReadOnly
      ]
  object ListDeviceEvents
      extends Stream[
        ListDeviceEventsRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.DeviceEvent.ReadOnly
      ]
  object ListDeviceEventsPaginated
      extends Effect[
        ListDeviceEventsRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.ListDeviceEventsResponse.ReadOnly
      ]
  object SendInvitation
      extends Effect[
        SendInvitationRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.SendInvitationResponse.ReadOnly
      ]
  object GetConferenceProvider
      extends Effect[
        GetConferenceProviderRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.GetConferenceProviderResponse.ReadOnly
      ]
  object GetNetworkProfile
      extends Effect[
        GetNetworkProfileRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.GetNetworkProfileResponse.ReadOnly
      ]
  object DisassociateDeviceFromRoom
      extends Effect[DisassociateDeviceFromRoomRequest, AwsError, ReadOnly]
  object GetSkillGroup
      extends Effect[
        GetSkillGroupRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.GetSkillGroupResponse.ReadOnly
      ]
  object ApproveSkill
      extends Effect[
        ApproveSkillRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.ApproveSkillResponse.ReadOnly
      ]
  object ListSkills
      extends Stream[
        ListSkillsRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.SkillSummary.ReadOnly
      ]
  object ListSkillsPaginated
      extends Effect[
        ListSkillsRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.ListSkillsResponse.ReadOnly
      ]
  object CreateUser
      extends Effect[
        CreateUserRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.CreateUserResponse.ReadOnly
      ]
  object UpdateSkillGroup
      extends Effect[
        UpdateSkillGroupRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.UpdateSkillGroupResponse.ReadOnly
      ]
  object DeleteSkillGroup
      extends Effect[
        DeleteSkillGroupRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.DeleteSkillGroupResponse.ReadOnly
      ]
  object RejectSkill
      extends Effect[
        RejectSkillRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.RejectSkillResponse.ReadOnly
      ]
  object DeleteBusinessReportSchedule
      extends Effect[
        DeleteBusinessReportScheduleRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.DeleteBusinessReportScheduleResponse.ReadOnly
      ]
  object GetAddressBook
      extends Effect[
        GetAddressBookRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.GetAddressBookResponse.ReadOnly
      ]
  object PutInvitationConfiguration
      extends Effect[
        PutInvitationConfigurationRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.PutInvitationConfigurationResponse.ReadOnly
      ]
  object ListBusinessReportSchedules
      extends Stream[
        ListBusinessReportSchedulesRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.BusinessReportSchedule.ReadOnly
      ]
  object ListBusinessReportSchedulesPaginated
      extends Effect[
        ListBusinessReportSchedulesRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.ListBusinessReportSchedulesResponse.ReadOnly
      ]
  object ListGatewayGroups
      extends Stream[
        ListGatewayGroupsRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.GatewayGroupSummary.ReadOnly
      ]
  object ListGatewayGroupsPaginated
      extends Effect[
        ListGatewayGroupsRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.ListGatewayGroupsResponse.ReadOnly
      ]
  object DeleteProfile
      extends Effect[
        DeleteProfileRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.DeleteProfileResponse.ReadOnly
      ]
  object StartSmartHomeApplianceDiscovery
      extends Effect[
        StartSmartHomeApplianceDiscoveryRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.StartSmartHomeApplianceDiscoveryResponse.ReadOnly
      ]
  object SendAnnouncement
      extends Effect[
        SendAnnouncementRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.SendAnnouncementResponse.ReadOnly
      ]
  object GetInvitationConfiguration
      extends Effect[
        GetInvitationConfigurationRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.GetInvitationConfigurationResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.UntagResourceResponse.ReadOnly
      ]
  object AssociateSkillGroupWithRoom
      extends Effect[
        AssociateSkillGroupWithRoomRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.AssociateSkillGroupWithRoomResponse.ReadOnly
      ]
  object DisassociateSkillGroupFromRoom
      extends Effect[
        DisassociateSkillGroupFromRoomRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.DisassociateSkillGroupFromRoomResponse.ReadOnly
      ]
  object StartDeviceSync
      extends Effect[
        StartDeviceSyncRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.StartDeviceSyncResponse.ReadOnly
      ]
  object AssociateDeviceWithRoom
      extends Effect[
        AssociateDeviceWithRoomRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.AssociateDeviceWithRoomResponse.ReadOnly
      ]
  object CreateRoom
      extends Effect[
        CreateRoomRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.CreateRoomResponse.ReadOnly
      ]
  object DeleteRoom
      extends Effect[
        DeleteRoomRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.DeleteRoomResponse.ReadOnly
      ]
  object GetProfile
      extends Effect[
        GetProfileRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.GetProfileResponse.ReadOnly
      ]
  object ForgetSmartHomeAppliances
      extends Effect[
        ForgetSmartHomeAppliancesRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.ForgetSmartHomeAppliancesResponse.ReadOnly
      ]
  object GetConferencePreference
      extends Effect[
        GetConferencePreferenceRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.GetConferencePreferenceResponse.ReadOnly
      ]
  object UpdateAddressBook
      extends Effect[
        UpdateAddressBookRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.UpdateAddressBookResponse.ReadOnly
      ]
  object DisassociateSkillFromUsers
      extends Effect[
        DisassociateSkillFromUsersRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.DisassociateSkillFromUsersResponse.ReadOnly
      ]
  object UpdateDevice
      extends Effect[
        UpdateDeviceRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.UpdateDeviceResponse.ReadOnly
      ]
  object SearchRooms
      extends Effect[SearchRoomsRequest, AwsError, StreamingOutputResult[
        Any,
        zio.aws.alexaforbusiness.model.SearchRoomsResponse.ReadOnly,
        zio.aws.alexaforbusiness.model.RoomData.ReadOnly
      ]]
  object SearchRoomsPaginated
      extends Effect[
        SearchRoomsRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.SearchRoomsResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.TagResourceResponse.ReadOnly
      ]
  object DisassociateContactFromAddressBook
      extends Effect[
        DisassociateContactFromAddressBookRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.DisassociateContactFromAddressBookResponse.ReadOnly
      ]
  object CreateProfile
      extends Effect[
        CreateProfileRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.CreateProfileResponse.ReadOnly
      ]
  object DeleteNetworkProfile
      extends Effect[
        DeleteNetworkProfileRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.DeleteNetworkProfileResponse.ReadOnly
      ]
  object ListSmartHomeAppliances
      extends Stream[
        ListSmartHomeAppliancesRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.SmartHomeAppliance.ReadOnly
      ]
  object ListSmartHomeAppliancesPaginated
      extends Effect[
        ListSmartHomeAppliancesRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.ListSmartHomeAppliancesResponse.ReadOnly
      ]
  object GetRoom
      extends Effect[
        GetRoomRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.GetRoomResponse.ReadOnly
      ]
  object DeleteUser
      extends Effect[
        DeleteUserRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.DeleteUserResponse.ReadOnly
      ]
  object PutConferencePreference
      extends Effect[
        PutConferencePreferenceRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.PutConferencePreferenceResponse.ReadOnly
      ]
  object DeleteGatewayGroup
      extends Effect[
        DeleteGatewayGroupRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.DeleteGatewayGroupResponse.ReadOnly
      ]
  object SearchDevices
      extends Effect[SearchDevicesRequest, AwsError, StreamingOutputResult[
        Any,
        zio.aws.alexaforbusiness.model.SearchDevicesResponse.ReadOnly,
        zio.aws.alexaforbusiness.model.DeviceData.ReadOnly
      ]]
  object SearchDevicesPaginated
      extends Effect[
        SearchDevicesRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.SearchDevicesResponse.ReadOnly
      ]
  object GetContact
      extends Effect[
        GetContactRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.GetContactResponse.ReadOnly
      ]
  object ResolveRoom
      extends Effect[
        ResolveRoomRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.ResolveRoomResponse.ReadOnly
      ]
  object RegisterAVSDevice
      extends Effect[
        RegisterAvsDeviceRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.RegisterAvsDeviceResponse.ReadOnly
      ]
  object UpdateProfile
      extends Effect[
        UpdateProfileRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.UpdateProfileResponse.ReadOnly
      ]
  object CreateSkillGroup
      extends Effect[
        CreateSkillGroupRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.CreateSkillGroupResponse.ReadOnly
      ]
  object SearchProfiles
      extends Effect[SearchProfilesRequest, AwsError, StreamingOutputResult[
        Any,
        zio.aws.alexaforbusiness.model.SearchProfilesResponse.ReadOnly,
        zio.aws.alexaforbusiness.model.ProfileData.ReadOnly
      ]]
  object SearchProfilesPaginated
      extends Effect[
        SearchProfilesRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.SearchProfilesResponse.ReadOnly
      ]
  object DeleteDeviceUsageData
      extends Effect[
        DeleteDeviceUsageDataRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.DeleteDeviceUsageDataResponse.ReadOnly
      ]
  object SearchContacts
      extends Effect[SearchContactsRequest, AwsError, StreamingOutputResult[
        Any,
        zio.aws.alexaforbusiness.model.SearchContactsResponse.ReadOnly,
        zio.aws.alexaforbusiness.model.ContactData.ReadOnly
      ]]
  object SearchContactsPaginated
      extends Effect[
        SearchContactsRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.SearchContactsResponse.ReadOnly
      ]
  object GetDevice
      extends Effect[
        GetDeviceRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.GetDeviceResponse.ReadOnly
      ]
  object CreateNetworkProfile
      extends Effect[
        CreateNetworkProfileRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.CreateNetworkProfileResponse.ReadOnly
      ]
  object CreateBusinessReportSchedule
      extends Effect[
        CreateBusinessReportScheduleRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.CreateBusinessReportScheduleResponse.ReadOnly
      ]
  object GetGateway
      extends Effect[
        GetGatewayRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.GetGatewayResponse.ReadOnly
      ]
  object SearchNetworkProfiles
      extends Effect[
        SearchNetworkProfilesRequest,
        AwsError,
        StreamingOutputResult[
          Any,
          zio.aws.alexaforbusiness.model.SearchNetworkProfilesResponse.ReadOnly,
          zio.aws.alexaforbusiness.model.NetworkProfileData.ReadOnly
        ]
      ]
  object SearchNetworkProfilesPaginated
      extends Effect[
        SearchNetworkProfilesRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.SearchNetworkProfilesResponse.ReadOnly
      ]
  object SearchAddressBooks
      extends Effect[SearchAddressBooksRequest, AwsError, StreamingOutputResult[
        Any,
        zio.aws.alexaforbusiness.model.SearchAddressBooksResponse.ReadOnly,
        zio.aws.alexaforbusiness.model.AddressBookData.ReadOnly
      ]]
  object SearchAddressBooksPaginated
      extends Effect[
        SearchAddressBooksRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.SearchAddressBooksResponse.ReadOnly
      ]
  object PutRoomSkillParameter
      extends Effect[
        PutRoomSkillParameterRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.PutRoomSkillParameterResponse.ReadOnly
      ]
  object ListGateways
      extends Stream[
        ListGatewaysRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.GatewaySummary.ReadOnly
      ]
  object ListGatewaysPaginated
      extends Effect[
        ListGatewaysRequest,
        AwsError,
        zio.aws.alexaforbusiness.model.ListGatewaysResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, AlexaForBusiness] = zio.ZLayer {
    ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, AlexaForBusiness] { rts =>
        ZIO.succeed {
          new AlexaForBusiness {
            val api: AlexaForBusinessAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): AlexaForBusiness = this
            def updateContact(request: UpdateContactRequest): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.UpdateContactResponse.ReadOnly
            ] = proxy(UpdateContact, request)
            def deleteRoomSkillParameter(
                request: DeleteRoomSkillParameterRequest
            ): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.DeleteRoomSkillParameterResponse.ReadOnly
            ] = proxy(DeleteRoomSkillParameter, request)
            def associateSkillWithUsers(
                request: AssociateSkillWithUsersRequest
            ): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.AssociateSkillWithUsersResponse.ReadOnly
            ] = proxy(AssociateSkillWithUsers, request)
            def deleteSkillAuthorization(
                request: DeleteSkillAuthorizationRequest
            ): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.DeleteSkillAuthorizationResponse.ReadOnly
            ] = proxy(DeleteSkillAuthorization, request)
            def deleteConferenceProvider(
                request: DeleteConferenceProviderRequest
            ): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.DeleteConferenceProviderResponse.ReadOnly
            ] = proxy(DeleteConferenceProvider, request)
            def updateGateway(request: UpdateGatewayRequest): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.UpdateGatewayResponse.ReadOnly
            ] = proxy(UpdateGateway, request)
            def updateGatewayGroup(request: UpdateGatewayGroupRequest): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.UpdateGatewayGroupResponse.ReadOnly
            ] = proxy(UpdateGatewayGroup, request)
            def searchUsers(
                request: SearchUsersRequest
            ): ZIO[Any, AwsError, StreamingOutputResult[
              Any,
              zio.aws.alexaforbusiness.model.SearchUsersResponse.ReadOnly,
              zio.aws.alexaforbusiness.model.UserData.ReadOnly
            ]] = proxy(SearchUsers, request)
            def searchUsersPaginated(request: SearchUsersRequest): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.SearchUsersResponse.ReadOnly
            ] = proxy(SearchUsersPaginated, request)
            def searchSkillGroups(
                request: SearchSkillGroupsRequest
            ): ZIO[Any, AwsError, StreamingOutputResult[
              Any,
              zio.aws.alexaforbusiness.model.SearchSkillGroupsResponse.ReadOnly,
              zio.aws.alexaforbusiness.model.SkillGroupData.ReadOnly
            ]] = proxy(SearchSkillGroups, request)
            def searchSkillGroupsPaginated(
                request: SearchSkillGroupsRequest
            ): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.SearchSkillGroupsResponse.ReadOnly
            ] = proxy(SearchSkillGroupsPaginated, request)
            def associateSkillWithSkillGroup(
                request: AssociateSkillWithSkillGroupRequest
            ): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.AssociateSkillWithSkillGroupResponse.ReadOnly
            ] = proxy(AssociateSkillWithSkillGroup, request)
            def revokeInvitation(request: RevokeInvitationRequest): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.RevokeInvitationResponse.ReadOnly
            ] = proxy(RevokeInvitation, request)
            def listSkillsStoreCategories(
                request: ListSkillsStoreCategoriesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.alexaforbusiness.model.Category.ReadOnly
            ] = rts.unsafeRun(proxy(ListSkillsStoreCategories, request))
            def listSkillsStoreCategoriesPaginated(
                request: ListSkillsStoreCategoriesRequest
            ): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.ListSkillsStoreCategoriesResponse.ReadOnly
            ] = proxy(ListSkillsStoreCategoriesPaginated, request)
            def disassociateSkillFromSkillGroup(
                request: DisassociateSkillFromSkillGroupRequest
            ): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.DisassociateSkillFromSkillGroupResponse.ReadOnly
            ] = proxy(DisassociateSkillFromSkillGroup, request)
            def getRoomSkillParameter(
                request: GetRoomSkillParameterRequest
            ): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.GetRoomSkillParameterResponse.ReadOnly
            ] = proxy(GetRoomSkillParameter, request)
            def updateNetworkProfile(request: UpdateNetworkProfileRequest): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.UpdateNetworkProfileResponse.ReadOnly
            ] = proxy(UpdateNetworkProfile, request)
            def associateContactWithAddressBook(
                request: AssociateContactWithAddressBookRequest
            ): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.AssociateContactWithAddressBookResponse.ReadOnly
            ] = proxy(AssociateContactWithAddressBook, request)
            def listConferenceProviders(
                request: ListConferenceProvidersRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.alexaforbusiness.model.ConferenceProvider.ReadOnly
            ] = rts.unsafeRun(proxy(ListConferenceProviders, request))
            def listConferenceProvidersPaginated(
                request: ListConferenceProvidersRequest
            ): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.ListConferenceProvidersResponse.ReadOnly
            ] = proxy(ListConferenceProvidersPaginated, request)
            def listSkillsStoreSkillsByCategory(
                request: ListSkillsStoreSkillsByCategoryRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.alexaforbusiness.model.SkillsStoreSkill.ReadOnly
            ] = rts.unsafeRun(proxy(ListSkillsStoreSkillsByCategory, request))
            def listSkillsStoreSkillsByCategoryPaginated(
                request: ListSkillsStoreSkillsByCategoryRequest
            ): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.ListSkillsStoreSkillsByCategoryResponse.ReadOnly
            ] = proxy(ListSkillsStoreSkillsByCategoryPaginated, request)
            def listTags(request: ListTagsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.alexaforbusiness.model.Tag.ReadOnly
            ] = rts.unsafeRun(proxy(ListTags, request))
            def listTagsPaginated(request: ListTagsRequest): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.ListTagsResponse.ReadOnly
            ] = proxy(ListTagsPaginated, request)
            def deleteAddressBook(request: DeleteAddressBookRequest): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.DeleteAddressBookResponse.ReadOnly
            ] = proxy(DeleteAddressBook, request)
            def createConferenceProvider(
                request: CreateConferenceProviderRequest
            ): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.CreateConferenceProviderResponse.ReadOnly
            ] = proxy(CreateConferenceProvider, request)
            def deleteDevice(request: DeleteDeviceRequest): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.DeleteDeviceResponse.ReadOnly
            ] = proxy(DeleteDevice, request)
            def createGatewayGroup(request: CreateGatewayGroupRequest): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.CreateGatewayGroupResponse.ReadOnly
            ] = proxy(CreateGatewayGroup, request)
            def getGatewayGroup(request: GetGatewayGroupRequest): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.GetGatewayGroupResponse.ReadOnly
            ] = proxy(GetGatewayGroup, request)
            def updateRoom(request: UpdateRoomRequest): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.UpdateRoomResponse.ReadOnly
            ] = proxy(UpdateRoom, request)
            def deleteContact(request: DeleteContactRequest): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.DeleteContactResponse.ReadOnly
            ] = proxy(DeleteContact, request)
            def updateBusinessReportSchedule(
                request: UpdateBusinessReportScheduleRequest
            ): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.UpdateBusinessReportScheduleResponse.ReadOnly
            ] = proxy(UpdateBusinessReportSchedule, request)
            def associateDeviceWithNetworkProfile(
                request: AssociateDeviceWithNetworkProfileRequest
            ): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.AssociateDeviceWithNetworkProfileResponse.ReadOnly
            ] = proxy(AssociateDeviceWithNetworkProfile, request)
            def createContact(request: CreateContactRequest): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.CreateContactResponse.ReadOnly
            ] = proxy(CreateContact, request)
            def putSkillAuthorization(
                request: PutSkillAuthorizationRequest
            ): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.PutSkillAuthorizationResponse.ReadOnly
            ] = proxy(PutSkillAuthorization, request)
            def createAddressBook(request: CreateAddressBookRequest): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.CreateAddressBookResponse.ReadOnly
            ] = proxy(CreateAddressBook, request)
            def updateConferenceProvider(
                request: UpdateConferenceProviderRequest
            ): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.UpdateConferenceProviderResponse.ReadOnly
            ] = proxy(UpdateConferenceProvider, request)
            def listDeviceEvents(request: ListDeviceEventsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.alexaforbusiness.model.DeviceEvent.ReadOnly
            ] = rts.unsafeRun(proxy(ListDeviceEvents, request))
            def listDeviceEventsPaginated(request: ListDeviceEventsRequest): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.ListDeviceEventsResponse.ReadOnly
            ] = proxy(ListDeviceEventsPaginated, request)
            def sendInvitation(request: SendInvitationRequest): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.SendInvitationResponse.ReadOnly
            ] = proxy(SendInvitation, request)
            def getConferenceProvider(
                request: GetConferenceProviderRequest
            ): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.GetConferenceProviderResponse.ReadOnly
            ] = proxy(GetConferenceProvider, request)
            def getNetworkProfile(request: GetNetworkProfileRequest): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.GetNetworkProfileResponse.ReadOnly
            ] = proxy(GetNetworkProfile, request)
            def disassociateDeviceFromRoom(
                request: DisassociateDeviceFromRoomRequest
            ): IO[AwsError, ReadOnly] =
              proxy(DisassociateDeviceFromRoom, request)
            def getSkillGroup(request: GetSkillGroupRequest): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.GetSkillGroupResponse.ReadOnly
            ] = proxy(GetSkillGroup, request)
            def approveSkill(request: ApproveSkillRequest): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.ApproveSkillResponse.ReadOnly
            ] = proxy(ApproveSkill, request)
            def listSkills(request: ListSkillsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.alexaforbusiness.model.SkillSummary.ReadOnly
            ] = rts.unsafeRun(proxy(ListSkills, request))
            def listSkillsPaginated(request: ListSkillsRequest): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.ListSkillsResponse.ReadOnly
            ] = proxy(ListSkillsPaginated, request)
            def createUser(request: CreateUserRequest): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.CreateUserResponse.ReadOnly
            ] = proxy(CreateUser, request)
            def updateSkillGroup(request: UpdateSkillGroupRequest): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.UpdateSkillGroupResponse.ReadOnly
            ] = proxy(UpdateSkillGroup, request)
            def deleteSkillGroup(request: DeleteSkillGroupRequest): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.DeleteSkillGroupResponse.ReadOnly
            ] = proxy(DeleteSkillGroup, request)
            def rejectSkill(request: RejectSkillRequest): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.RejectSkillResponse.ReadOnly
            ] = proxy(RejectSkill, request)
            def deleteBusinessReportSchedule(
                request: DeleteBusinessReportScheduleRequest
            ): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.DeleteBusinessReportScheduleResponse.ReadOnly
            ] = proxy(DeleteBusinessReportSchedule, request)
            def getAddressBook(request: GetAddressBookRequest): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.GetAddressBookResponse.ReadOnly
            ] = proxy(GetAddressBook, request)
            def putInvitationConfiguration(
                request: PutInvitationConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.PutInvitationConfigurationResponse.ReadOnly
            ] = proxy(PutInvitationConfiguration, request)
            def listBusinessReportSchedules(
                request: ListBusinessReportSchedulesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.alexaforbusiness.model.BusinessReportSchedule.ReadOnly
            ] = rts.unsafeRun(proxy(ListBusinessReportSchedules, request))
            def listBusinessReportSchedulesPaginated(
                request: ListBusinessReportSchedulesRequest
            ): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.ListBusinessReportSchedulesResponse.ReadOnly
            ] = proxy(ListBusinessReportSchedulesPaginated, request)
            def listGatewayGroups(request: ListGatewayGroupsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.alexaforbusiness.model.GatewayGroupSummary.ReadOnly
            ] = rts.unsafeRun(proxy(ListGatewayGroups, request))
            def listGatewayGroupsPaginated(
                request: ListGatewayGroupsRequest
            ): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.ListGatewayGroupsResponse.ReadOnly
            ] = proxy(ListGatewayGroupsPaginated, request)
            def deleteProfile(request: DeleteProfileRequest): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.DeleteProfileResponse.ReadOnly
            ] = proxy(DeleteProfile, request)
            def startSmartHomeApplianceDiscovery(
                request: StartSmartHomeApplianceDiscoveryRequest
            ): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.StartSmartHomeApplianceDiscoveryResponse.ReadOnly
            ] = proxy(StartSmartHomeApplianceDiscovery, request)
            def sendAnnouncement(request: SendAnnouncementRequest): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.SendAnnouncementResponse.ReadOnly
            ] = proxy(SendAnnouncement, request)
            def getInvitationConfiguration(
                request: GetInvitationConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.GetInvitationConfigurationResponse.ReadOnly
            ] = proxy(GetInvitationConfiguration, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def associateSkillGroupWithRoom(
                request: AssociateSkillGroupWithRoomRequest
            ): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.AssociateSkillGroupWithRoomResponse.ReadOnly
            ] = proxy(AssociateSkillGroupWithRoom, request)
            def disassociateSkillGroupFromRoom(
                request: DisassociateSkillGroupFromRoomRequest
            ): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.DisassociateSkillGroupFromRoomResponse.ReadOnly
            ] = proxy(DisassociateSkillGroupFromRoom, request)
            def startDeviceSync(request: StartDeviceSyncRequest): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.StartDeviceSyncResponse.ReadOnly
            ] = proxy(StartDeviceSync, request)
            def associateDeviceWithRoom(
                request: AssociateDeviceWithRoomRequest
            ): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.AssociateDeviceWithRoomResponse.ReadOnly
            ] = proxy(AssociateDeviceWithRoom, request)
            def createRoom(request: CreateRoomRequest): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.CreateRoomResponse.ReadOnly
            ] = proxy(CreateRoom, request)
            def deleteRoom(request: DeleteRoomRequest): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.DeleteRoomResponse.ReadOnly
            ] = proxy(DeleteRoom, request)
            def getProfile(request: GetProfileRequest): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.GetProfileResponse.ReadOnly
            ] = proxy(GetProfile, request)
            def forgetSmartHomeAppliances(
                request: ForgetSmartHomeAppliancesRequest
            ): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.ForgetSmartHomeAppliancesResponse.ReadOnly
            ] = proxy(ForgetSmartHomeAppliances, request)
            def getConferencePreference(
                request: GetConferencePreferenceRequest
            ): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.GetConferencePreferenceResponse.ReadOnly
            ] = proxy(GetConferencePreference, request)
            def updateAddressBook(request: UpdateAddressBookRequest): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.UpdateAddressBookResponse.ReadOnly
            ] = proxy(UpdateAddressBook, request)
            def disassociateSkillFromUsers(
                request: DisassociateSkillFromUsersRequest
            ): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.DisassociateSkillFromUsersResponse.ReadOnly
            ] = proxy(DisassociateSkillFromUsers, request)
            def updateDevice(request: UpdateDeviceRequest): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.UpdateDeviceResponse.ReadOnly
            ] = proxy(UpdateDevice, request)
            def searchRooms(
                request: SearchRoomsRequest
            ): ZIO[Any, AwsError, StreamingOutputResult[
              Any,
              zio.aws.alexaforbusiness.model.SearchRoomsResponse.ReadOnly,
              zio.aws.alexaforbusiness.model.RoomData.ReadOnly
            ]] = proxy(SearchRooms, request)
            def searchRoomsPaginated(request: SearchRoomsRequest): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.SearchRoomsResponse.ReadOnly
            ] = proxy(SearchRoomsPaginated, request)
            def tagResource(request: TagResourceRequest): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.TagResourceResponse.ReadOnly
            ] = proxy(TagResource, request)
            def disassociateContactFromAddressBook(
                request: DisassociateContactFromAddressBookRequest
            ): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.DisassociateContactFromAddressBookResponse.ReadOnly
            ] = proxy(DisassociateContactFromAddressBook, request)
            def createProfile(request: CreateProfileRequest): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.CreateProfileResponse.ReadOnly
            ] = proxy(CreateProfile, request)
            def deleteNetworkProfile(request: DeleteNetworkProfileRequest): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.DeleteNetworkProfileResponse.ReadOnly
            ] = proxy(DeleteNetworkProfile, request)
            def listSmartHomeAppliances(
                request: ListSmartHomeAppliancesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.alexaforbusiness.model.SmartHomeAppliance.ReadOnly
            ] = rts.unsafeRun(proxy(ListSmartHomeAppliances, request))
            def listSmartHomeAppliancesPaginated(
                request: ListSmartHomeAppliancesRequest
            ): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.ListSmartHomeAppliancesResponse.ReadOnly
            ] = proxy(ListSmartHomeAppliancesPaginated, request)
            def getRoom(request: GetRoomRequest): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.GetRoomResponse.ReadOnly
            ] = proxy(GetRoom, request)
            def deleteUser(request: DeleteUserRequest): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.DeleteUserResponse.ReadOnly
            ] = proxy(DeleteUser, request)
            def putConferencePreference(
                request: PutConferencePreferenceRequest
            ): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.PutConferencePreferenceResponse.ReadOnly
            ] = proxy(PutConferencePreference, request)
            def deleteGatewayGroup(request: DeleteGatewayGroupRequest): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.DeleteGatewayGroupResponse.ReadOnly
            ] = proxy(DeleteGatewayGroup, request)
            def searchDevices(
                request: SearchDevicesRequest
            ): ZIO[Any, AwsError, StreamingOutputResult[
              Any,
              zio.aws.alexaforbusiness.model.SearchDevicesResponse.ReadOnly,
              zio.aws.alexaforbusiness.model.DeviceData.ReadOnly
            ]] = proxy(SearchDevices, request)
            def searchDevicesPaginated(request: SearchDevicesRequest): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.SearchDevicesResponse.ReadOnly
            ] = proxy(SearchDevicesPaginated, request)
            def getContact(request: GetContactRequest): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.GetContactResponse.ReadOnly
            ] = proxy(GetContact, request)
            def resolveRoom(request: ResolveRoomRequest): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.ResolveRoomResponse.ReadOnly
            ] = proxy(ResolveRoom, request)
            def registerAVSDevice(request: RegisterAvsDeviceRequest): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.RegisterAvsDeviceResponse.ReadOnly
            ] = proxy(RegisterAVSDevice, request)
            def updateProfile(request: UpdateProfileRequest): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.UpdateProfileResponse.ReadOnly
            ] = proxy(UpdateProfile, request)
            def createSkillGroup(request: CreateSkillGroupRequest): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.CreateSkillGroupResponse.ReadOnly
            ] = proxy(CreateSkillGroup, request)
            def searchProfiles(
                request: SearchProfilesRequest
            ): ZIO[Any, AwsError, StreamingOutputResult[
              Any,
              zio.aws.alexaforbusiness.model.SearchProfilesResponse.ReadOnly,
              zio.aws.alexaforbusiness.model.ProfileData.ReadOnly
            ]] = proxy(SearchProfiles, request)
            def searchProfilesPaginated(request: SearchProfilesRequest): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.SearchProfilesResponse.ReadOnly
            ] = proxy(SearchProfilesPaginated, request)
            def deleteDeviceUsageData(
                request: DeleteDeviceUsageDataRequest
            ): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.DeleteDeviceUsageDataResponse.ReadOnly
            ] = proxy(DeleteDeviceUsageData, request)
            def searchContacts(
                request: SearchContactsRequest
            ): ZIO[Any, AwsError, StreamingOutputResult[
              Any,
              zio.aws.alexaforbusiness.model.SearchContactsResponse.ReadOnly,
              zio.aws.alexaforbusiness.model.ContactData.ReadOnly
            ]] = proxy(SearchContacts, request)
            def searchContactsPaginated(request: SearchContactsRequest): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.SearchContactsResponse.ReadOnly
            ] = proxy(SearchContactsPaginated, request)
            def getDevice(request: GetDeviceRequest): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.GetDeviceResponse.ReadOnly
            ] = proxy(GetDevice, request)
            def createNetworkProfile(request: CreateNetworkProfileRequest): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.CreateNetworkProfileResponse.ReadOnly
            ] = proxy(CreateNetworkProfile, request)
            def createBusinessReportSchedule(
                request: CreateBusinessReportScheduleRequest
            ): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.CreateBusinessReportScheduleResponse.ReadOnly
            ] = proxy(CreateBusinessReportSchedule, request)
            def getGateway(request: GetGatewayRequest): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.GetGatewayResponse.ReadOnly
            ] = proxy(GetGateway, request)
            def searchNetworkProfiles(
                request: SearchNetworkProfilesRequest
            ): ZIO[Any, AwsError, StreamingOutputResult[
              Any,
              zio.aws.alexaforbusiness.model.SearchNetworkProfilesResponse.ReadOnly,
              zio.aws.alexaforbusiness.model.NetworkProfileData.ReadOnly
            ]] = proxy(SearchNetworkProfiles, request)
            def searchNetworkProfilesPaginated(
                request: SearchNetworkProfilesRequest
            ): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.SearchNetworkProfilesResponse.ReadOnly
            ] = proxy(SearchNetworkProfilesPaginated, request)
            def searchAddressBooks(
                request: SearchAddressBooksRequest
            ): ZIO[Any, AwsError, StreamingOutputResult[
              Any,
              zio.aws.alexaforbusiness.model.SearchAddressBooksResponse.ReadOnly,
              zio.aws.alexaforbusiness.model.AddressBookData.ReadOnly
            ]] = proxy(SearchAddressBooks, request)
            def searchAddressBooksPaginated(
                request: SearchAddressBooksRequest
            ): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.SearchAddressBooksResponse.ReadOnly
            ] = proxy(SearchAddressBooksPaginated, request)
            def putRoomSkillParameter(
                request: PutRoomSkillParameterRequest
            ): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.PutRoomSkillParameterResponse.ReadOnly
            ] = proxy(PutRoomSkillParameter, request)
            def listGateways(request: ListGatewaysRequest): ZStream[
              Any,
              AwsError,
              zio.aws.alexaforbusiness.model.GatewaySummary.ReadOnly
            ] = rts.unsafeRun(proxy(ListGateways, request))
            def listGatewaysPaginated(request: ListGatewaysRequest): IO[
              AwsError,
              zio.aws.alexaforbusiness.model.ListGatewaysResponse.ReadOnly
            ] = proxy(ListGatewaysPaginated, request)
          }
        }
      }
    }
  }
}
