package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.{
  SkillId,
  SkillName,
  ShortDescription,
  IconUrl,
  Utterance
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SkillsStoreSkill(
    skillId: Optional[SkillId] = Optional.Absent,
    skillName: Optional[SkillName] = Optional.Absent,
    shortDescription: Optional[ShortDescription] = Optional.Absent,
    iconUrl: Optional[IconUrl] = Optional.Absent,
    sampleUtterances: Optional[Iterable[Utterance]] = Optional.Absent,
    skillDetails: Optional[zio.aws.alexaforbusiness.model.SkillDetails] =
      Optional.Absent,
    supportsLinking: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.SkillsStoreSkill = {
    import SkillsStoreSkill.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.SkillsStoreSkill
      .builder()
      .optionallyWith(
        skillId.map(value => SkillId.unwrap(value): java.lang.String)
      )(_.skillId)
      .optionallyWith(
        skillName.map(value => SkillName.unwrap(value): java.lang.String)
      )(_.skillName)
      .optionallyWith(
        shortDescription.map(value =>
          ShortDescription.unwrap(value): java.lang.String
        )
      )(_.shortDescription)
      .optionallyWith(
        iconUrl.map(value => IconUrl.unwrap(value): java.lang.String)
      )(_.iconUrl)
      .optionallyWith(
        sampleUtterances.map(value =>
          value.map { item =>
            Utterance.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.sampleUtterances)
      .optionallyWith(skillDetails.map(value => value.buildAwsValue()))(
        _.skillDetails
      )
      .optionallyWith(supportsLinking.map(value => value: java.lang.Boolean))(
        _.supportsLinking
      )
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.SkillsStoreSkill.ReadOnly =
    zio.aws.alexaforbusiness.model.SkillsStoreSkill.wrap(buildAwsValue())
}
object SkillsStoreSkill {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.SkillsStoreSkill
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.SkillsStoreSkill =
      zio.aws.alexaforbusiness.model.SkillsStoreSkill(
        skillId.map(value => value),
        skillName.map(value => value),
        shortDescription.map(value => value),
        iconUrl.map(value => value),
        sampleUtterances.map(value => value),
        skillDetails.map(value => value.asEditable),
        supportsLinking.map(value => value)
      )
    def skillId: Optional[SkillId]
    def skillName: Optional[SkillName]
    def shortDescription: Optional[ShortDescription]
    def iconUrl: Optional[IconUrl]
    def sampleUtterances: Optional[List[Utterance]]
    def skillDetails
        : Optional[zio.aws.alexaforbusiness.model.SkillDetails.ReadOnly]
    def supportsLinking: Optional[Boolean]
    def getSkillId: ZIO[Any, AwsError, SkillId] =
      AwsError.unwrapOptionField("skillId", skillId)
    def getSkillName: ZIO[Any, AwsError, SkillName] =
      AwsError.unwrapOptionField("skillName", skillName)
    def getShortDescription: ZIO[Any, AwsError, ShortDescription] =
      AwsError.unwrapOptionField("shortDescription", shortDescription)
    def getIconUrl: ZIO[Any, AwsError, IconUrl] =
      AwsError.unwrapOptionField("iconUrl", iconUrl)
    def getSampleUtterances: ZIO[Any, AwsError, List[Utterance]] =
      AwsError.unwrapOptionField("sampleUtterances", sampleUtterances)
    def getSkillDetails: ZIO[
      Any,
      AwsError,
      zio.aws.alexaforbusiness.model.SkillDetails.ReadOnly
    ] = AwsError.unwrapOptionField("skillDetails", skillDetails)
    def getSupportsLinking: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("supportsLinking", supportsLinking)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.SkillsStoreSkill
  ) extends zio.aws.alexaforbusiness.model.SkillsStoreSkill.ReadOnly {
    override val skillId: Optional[SkillId] = zio.aws.core.internal
      .optionalFromNullable(impl.skillId())
      .map(value => zio.aws.alexaforbusiness.model.primitives.SkillId(value))
    override val skillName: Optional[SkillName] = zio.aws.core.internal
      .optionalFromNullable(impl.skillName())
      .map(value => zio.aws.alexaforbusiness.model.primitives.SkillName(value))
    override val shortDescription: Optional[ShortDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.shortDescription())
        .map(value =>
          zio.aws.alexaforbusiness.model.primitives.ShortDescription(value)
        )
    override val iconUrl: Optional[IconUrl] = zio.aws.core.internal
      .optionalFromNullable(impl.iconUrl())
      .map(value => zio.aws.alexaforbusiness.model.primitives.IconUrl(value))
    override val sampleUtterances: Optional[List[Utterance]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sampleUtterances())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.alexaforbusiness.model.primitives.Utterance(item)
          }.toList
        )
    override val skillDetails
        : Optional[zio.aws.alexaforbusiness.model.SkillDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.skillDetails())
        .map(value => zio.aws.alexaforbusiness.model.SkillDetails.wrap(value))
    override val supportsLinking: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.supportsLinking())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.SkillsStoreSkill
  ): zio.aws.alexaforbusiness.model.SkillsStoreSkill.ReadOnly = new Wrapper(
    impl
  )
}
