package zio.aws.alexaforbusiness.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.alexaforbusiness.model.primitives.Minutes
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class InstantBooking(
    durationInMinutes: Optional[Minutes] = Optional.Absent,
    enabled: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.InstantBooking = {
    import InstantBooking.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.InstantBooking
      .builder()
      .optionallyWith(
        durationInMinutes.map(value => Minutes.unwrap(value): Integer)
      )(_.durationInMinutes)
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.InstantBooking.ReadOnly =
    zio.aws.alexaforbusiness.model.InstantBooking.wrap(buildAwsValue())
}
object InstantBooking {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.InstantBooking
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.InstantBooking =
      zio.aws.alexaforbusiness.model.InstantBooking(
        durationInMinutes.map(value => value),
        enabled.map(value => value)
      )
    def durationInMinutes: Optional[Minutes]
    def enabled: Optional[Boolean]
    def getDurationInMinutes: ZIO[Any, AwsError, Minutes] =
      AwsError.unwrapOptionField("durationInMinutes", durationInMinutes)
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.InstantBooking
  ) extends zio.aws.alexaforbusiness.model.InstantBooking.ReadOnly {
    override val durationInMinutes: Optional[Minutes] = zio.aws.core.internal
      .optionalFromNullable(impl.durationInMinutes())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Minutes(value))
    override val enabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.InstantBooking
  ): zio.aws.alexaforbusiness.model.InstantBooking.ReadOnly = new Wrapper(impl)
}
