package zio.aws.alexaforbusiness.model
import scala.jdk.CollectionConverters._
sealed trait DeviceEventType {
  def unwrap
      : software.amazon.awssdk.services.alexaforbusiness.model.DeviceEventType
}
object DeviceEventType {
  def wrap(
      value: software.amazon.awssdk.services.alexaforbusiness.model.DeviceEventType
  ): zio.aws.alexaforbusiness.model.DeviceEventType = value match {
    case software.amazon.awssdk.services.alexaforbusiness.model.DeviceEventType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.DeviceEventType.CONNECTION_STATUS =>
      val r = CONNECTION_STATUS
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.DeviceEventType.DEVICE_STATUS =>
      val r = DEVICE_STATUS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.alexaforbusiness.model.DeviceEventType {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.DeviceEventType =
      software.amazon.awssdk.services.alexaforbusiness.model.DeviceEventType.UNKNOWN_TO_SDK_VERSION
  }
  case object CONNECTION_STATUS
      extends zio.aws.alexaforbusiness.model.DeviceEventType {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.DeviceEventType =
      software.amazon.awssdk.services.alexaforbusiness.model.DeviceEventType.CONNECTION_STATUS
  }
  case object DEVICE_STATUS
      extends zio.aws.alexaforbusiness.model.DeviceEventType {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.DeviceEventType =
      software.amazon.awssdk.services.alexaforbusiness.model.DeviceEventType.DEVICE_STATUS
  }
}
