package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.SkillId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ApproveSkillRequest(skillId: SkillId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.ApproveSkillRequest = {
    import ApproveSkillRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.ApproveSkillRequest
      .builder()
      .skillId(SkillId.unwrap(skillId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.ApproveSkillRequest.ReadOnly =
    zio.aws.alexaforbusiness.model.ApproveSkillRequest.wrap(buildAwsValue())
}
object ApproveSkillRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.ApproveSkillRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.ApproveSkillRequest =
      zio.aws.alexaforbusiness.model.ApproveSkillRequest(skillId)
    def skillId: SkillId
    def getSkillId: ZIO[Any, Nothing, SkillId] = ZIO.succeed(skillId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.ApproveSkillRequest
  ) extends zio.aws.alexaforbusiness.model.ApproveSkillRequest.ReadOnly {
    override val skillId: SkillId =
      zio.aws.alexaforbusiness.model.primitives.SkillId(impl.skillId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.ApproveSkillRequest
  ): zio.aws.alexaforbusiness.model.ApproveSkillRequest.ReadOnly = new Wrapper(
    impl
  )
}
