package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.TextValue
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class Text(
    locale: zio.aws.alexaforbusiness.model.Locale,
    value: TextValue
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.Text = {
    import Text.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.Text
      .builder()
      .locale(locale.unwrap)
      .value(TextValue.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.Text.ReadOnly =
    zio.aws.alexaforbusiness.model.Text.wrap(buildAwsValue())
}
object Text {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.Text
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.Text =
      zio.aws.alexaforbusiness.model.Text(locale, value)
    def locale: zio.aws.alexaforbusiness.model.Locale
    def value: TextValue
    def getLocale: ZIO[Any, Nothing, zio.aws.alexaforbusiness.model.Locale] =
      ZIO.succeed(locale)
    def getValue: ZIO[Any, Nothing, TextValue] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.Text
  ) extends zio.aws.alexaforbusiness.model.Text.ReadOnly {
    override val locale: zio.aws.alexaforbusiness.model.Locale =
      zio.aws.alexaforbusiness.model.Locale.wrap(impl.locale())
    override val value: TextValue =
      zio.aws.alexaforbusiness.model.primitives.TextValue(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.Text
  ): zio.aws.alexaforbusiness.model.Text.ReadOnly = new Wrapper(impl)
}
