package zio.aws.alexaforbusiness.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.alexaforbusiness.model.primitives.{TotalCount, NextToken}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class SearchRoomsResponse(
    rooms: Optional[Iterable[zio.aws.alexaforbusiness.model.RoomData]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    totalCount: Optional[TotalCount] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.SearchRoomsResponse = {
    import SearchRoomsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.SearchRoomsResponse
      .builder()
      .optionallyWith(
        rooms.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.rooms)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        totalCount.map(value => TotalCount.unwrap(value): Integer)
      )(_.totalCount)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.SearchRoomsResponse.ReadOnly =
    zio.aws.alexaforbusiness.model.SearchRoomsResponse.wrap(buildAwsValue())
}
object SearchRoomsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.SearchRoomsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.SearchRoomsResponse =
      zio.aws.alexaforbusiness.model.SearchRoomsResponse(
        rooms.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        totalCount.map(value => value)
      )
    def rooms: Optional[List[zio.aws.alexaforbusiness.model.RoomData.ReadOnly]]
    def nextToken: Optional[NextToken]
    def totalCount: Optional[TotalCount]
    def getRooms: ZIO[Any, AwsError, List[
      zio.aws.alexaforbusiness.model.RoomData.ReadOnly
    ]] = AwsError.unwrapOptionField("rooms", rooms)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getTotalCount: ZIO[Any, AwsError, TotalCount] =
      AwsError.unwrapOptionField("totalCount", totalCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.SearchRoomsResponse
  ) extends zio.aws.alexaforbusiness.model.SearchRoomsResponse.ReadOnly {
    override val rooms
        : Optional[List[zio.aws.alexaforbusiness.model.RoomData.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rooms())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.alexaforbusiness.model.RoomData.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.alexaforbusiness.model.primitives.NextToken(value))
    override val totalCount: Optional[TotalCount] = zio.aws.core.internal
      .optionalFromNullable(impl.totalCount())
      .map(value => zio.aws.alexaforbusiness.model.primitives.TotalCount(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.SearchRoomsResponse
  ): zio.aws.alexaforbusiness.model.SearchRoomsResponse.ReadOnly = new Wrapper(
    impl
  )
}
