package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.{
  Arn,
  NextWiFiPassword,
  NetworkProfileDescription,
  NetworkSsid,
  TrustAnchor,
  CurrentWiFiPassword,
  NetworkProfileName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class NetworkProfile(
    networkProfileArn: Optional[Arn] = Optional.Absent,
    networkProfileName: Optional[NetworkProfileName] = Optional.Absent,
    description: Optional[NetworkProfileDescription] = Optional.Absent,
    ssid: Optional[NetworkSsid] = Optional.Absent,
    securityType: Optional[zio.aws.alexaforbusiness.model.NetworkSecurityType] =
      Optional.Absent,
    eapMethod: Optional[zio.aws.alexaforbusiness.model.NetworkEapMethod] =
      Optional.Absent,
    currentPassword: Optional[CurrentWiFiPassword] = Optional.Absent,
    nextPassword: Optional[NextWiFiPassword] = Optional.Absent,
    certificateAuthorityArn: Optional[Arn] = Optional.Absent,
    trustAnchors: Optional[Iterable[TrustAnchor]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.NetworkProfile = {
    import NetworkProfile.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.NetworkProfile
      .builder()
      .optionallyWith(
        networkProfileArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.networkProfileArn)
      .optionallyWith(
        networkProfileName.map(value =>
          NetworkProfileName.unwrap(value): java.lang.String
        )
      )(_.networkProfileName)
      .optionallyWith(
        description.map(value =>
          NetworkProfileDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        ssid.map(value => NetworkSsid.unwrap(value): java.lang.String)
      )(_.ssid)
      .optionallyWith(securityType.map(value => value.unwrap))(_.securityType)
      .optionallyWith(eapMethod.map(value => value.unwrap))(_.eapMethod)
      .optionallyWith(
        currentPassword.map(value =>
          CurrentWiFiPassword.unwrap(value): java.lang.String
        )
      )(_.currentPassword)
      .optionallyWith(
        nextPassword.map(value =>
          NextWiFiPassword.unwrap(value): java.lang.String
        )
      )(_.nextPassword)
      .optionallyWith(
        certificateAuthorityArn.map(value =>
          Arn.unwrap(value): java.lang.String
        )
      )(_.certificateAuthorityArn)
      .optionallyWith(
        trustAnchors.map(value =>
          value.map { item =>
            TrustAnchor.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.trustAnchors)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.NetworkProfile.ReadOnly =
    zio.aws.alexaforbusiness.model.NetworkProfile.wrap(buildAwsValue())
}
object NetworkProfile {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.NetworkProfile
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.NetworkProfile =
      zio.aws.alexaforbusiness.model.NetworkProfile(
        networkProfileArn.map(value => value),
        networkProfileName.map(value => value),
        description.map(value => value),
        ssid.map(value => value),
        securityType.map(value => value),
        eapMethod.map(value => value),
        currentPassword.map(value => value),
        nextPassword.map(value => value),
        certificateAuthorityArn.map(value => value),
        trustAnchors.map(value => value)
      )
    def networkProfileArn: Optional[Arn]
    def networkProfileName: Optional[NetworkProfileName]
    def description: Optional[NetworkProfileDescription]
    def ssid: Optional[NetworkSsid]
    def securityType
        : Optional[zio.aws.alexaforbusiness.model.NetworkSecurityType]
    def eapMethod: Optional[zio.aws.alexaforbusiness.model.NetworkEapMethod]
    def currentPassword: Optional[CurrentWiFiPassword]
    def nextPassword: Optional[NextWiFiPassword]
    def certificateAuthorityArn: Optional[Arn]
    def trustAnchors: Optional[List[TrustAnchor]]
    def getNetworkProfileArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("networkProfileArn", networkProfileArn)
    def getNetworkProfileName: ZIO[Any, AwsError, NetworkProfileName] =
      AwsError.unwrapOptionField("networkProfileName", networkProfileName)
    def getDescription: ZIO[Any, AwsError, NetworkProfileDescription] =
      AwsError.unwrapOptionField("description", description)
    def getSsid: ZIO[Any, AwsError, NetworkSsid] =
      AwsError.unwrapOptionField("ssid", ssid)
    def getSecurityType: ZIO[
      Any,
      AwsError,
      zio.aws.alexaforbusiness.model.NetworkSecurityType
    ] = AwsError.unwrapOptionField("securityType", securityType)
    def getEapMethod
        : ZIO[Any, AwsError, zio.aws.alexaforbusiness.model.NetworkEapMethod] =
      AwsError.unwrapOptionField("eapMethod", eapMethod)
    def getCurrentPassword: ZIO[Any, AwsError, CurrentWiFiPassword] =
      AwsError.unwrapOptionField("currentPassword", currentPassword)
    def getNextPassword: ZIO[Any, AwsError, NextWiFiPassword] =
      AwsError.unwrapOptionField("nextPassword", nextPassword)
    def getCertificateAuthorityArn: ZIO[Any, AwsError, Arn] = AwsError
      .unwrapOptionField("certificateAuthorityArn", certificateAuthorityArn)
    def getTrustAnchors: ZIO[Any, AwsError, List[TrustAnchor]] =
      AwsError.unwrapOptionField("trustAnchors", trustAnchors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.NetworkProfile
  ) extends zio.aws.alexaforbusiness.model.NetworkProfile.ReadOnly {
    override val networkProfileArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.networkProfileArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
    override val networkProfileName: Optional[NetworkProfileName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkProfileName())
        .map(value =>
          zio.aws.alexaforbusiness.model.primitives.NetworkProfileName(value)
        )
    override val description: Optional[NetworkProfileDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.alexaforbusiness.model.primitives
            .NetworkProfileDescription(value)
        )
    override val ssid: Optional[NetworkSsid] = zio.aws.core.internal
      .optionalFromNullable(impl.ssid())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.NetworkSsid(value)
      )
    override val securityType
        : Optional[zio.aws.alexaforbusiness.model.NetworkSecurityType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityType())
        .map(value =>
          zio.aws.alexaforbusiness.model.NetworkSecurityType.wrap(value)
        )
    override val eapMethod
        : Optional[zio.aws.alexaforbusiness.model.NetworkEapMethod] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eapMethod())
        .map(value =>
          zio.aws.alexaforbusiness.model.NetworkEapMethod.wrap(value)
        )
    override val currentPassword: Optional[CurrentWiFiPassword] =
      zio.aws.core.internal
        .optionalFromNullable(impl.currentPassword())
        .map(value =>
          zio.aws.alexaforbusiness.model.primitives.CurrentWiFiPassword(value)
        )
    override val nextPassword: Optional[NextWiFiPassword] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextPassword())
        .map(value =>
          zio.aws.alexaforbusiness.model.primitives.NextWiFiPassword(value)
        )
    override val certificateAuthorityArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.certificateAuthorityArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
    override val trustAnchors: Optional[List[TrustAnchor]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trustAnchors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.alexaforbusiness.model.primitives.TrustAnchor(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.NetworkProfile
  ): zio.aws.alexaforbusiness.model.NetworkProfile.ReadOnly = new Wrapper(impl)
}
