package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class MeetingSetting(
    requirePin: zio.aws.alexaforbusiness.model.RequirePin
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.MeetingSetting = {
    import MeetingSetting.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.MeetingSetting
      .builder()
      .requirePin(requirePin.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.MeetingSetting.ReadOnly =
    zio.aws.alexaforbusiness.model.MeetingSetting.wrap(buildAwsValue())
}
object MeetingSetting {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.MeetingSetting
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.MeetingSetting =
      zio.aws.alexaforbusiness.model.MeetingSetting(requirePin)
    def requirePin: zio.aws.alexaforbusiness.model.RequirePin
    def getRequirePin
        : ZIO[Any, Nothing, zio.aws.alexaforbusiness.model.RequirePin] =
      ZIO.succeed(requirePin)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.MeetingSetting
  ) extends zio.aws.alexaforbusiness.model.MeetingSetting.ReadOnly {
    override val requirePin: zio.aws.alexaforbusiness.model.RequirePin =
      zio.aws.alexaforbusiness.model.RequirePin.wrap(impl.requirePin())
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.MeetingSetting
  ): zio.aws.alexaforbusiness.model.MeetingSetting.ReadOnly = new Wrapper(impl)
}
