package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class MeetingRoomConfiguration(
    roomUtilizationMetricsEnabled: Optional[Boolean] = Optional.Absent,
    endOfMeetingReminder: Optional[
      zio.aws.alexaforbusiness.model.EndOfMeetingReminder
    ] = Optional.Absent,
    instantBooking: Optional[zio.aws.alexaforbusiness.model.InstantBooking] =
      Optional.Absent,
    requireCheckIn: Optional[zio.aws.alexaforbusiness.model.RequireCheckIn] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.MeetingRoomConfiguration = {
    import MeetingRoomConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.MeetingRoomConfiguration
      .builder()
      .optionallyWith(
        roomUtilizationMetricsEnabled.map(value => value: java.lang.Boolean)
      )(_.roomUtilizationMetricsEnabled)
      .optionallyWith(endOfMeetingReminder.map(value => value.buildAwsValue()))(
        _.endOfMeetingReminder
      )
      .optionallyWith(instantBooking.map(value => value.buildAwsValue()))(
        _.instantBooking
      )
      .optionallyWith(requireCheckIn.map(value => value.buildAwsValue()))(
        _.requireCheckIn
      )
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.MeetingRoomConfiguration.ReadOnly =
    zio.aws.alexaforbusiness.model.MeetingRoomConfiguration
      .wrap(buildAwsValue())
}
object MeetingRoomConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.MeetingRoomConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.MeetingRoomConfiguration =
      zio.aws.alexaforbusiness.model.MeetingRoomConfiguration(
        roomUtilizationMetricsEnabled.map(value => value),
        endOfMeetingReminder.map(value => value.asEditable),
        instantBooking.map(value => value.asEditable),
        requireCheckIn.map(value => value.asEditable)
      )
    def roomUtilizationMetricsEnabled: Optional[Boolean]
    def endOfMeetingReminder
        : Optional[zio.aws.alexaforbusiness.model.EndOfMeetingReminder.ReadOnly]
    def instantBooking
        : Optional[zio.aws.alexaforbusiness.model.InstantBooking.ReadOnly]
    def requireCheckIn
        : Optional[zio.aws.alexaforbusiness.model.RequireCheckIn.ReadOnly]
    def getRoomUtilizationMetricsEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "roomUtilizationMetricsEnabled",
        roomUtilizationMetricsEnabled
      )
    def getEndOfMeetingReminder: ZIO[
      Any,
      AwsError,
      zio.aws.alexaforbusiness.model.EndOfMeetingReminder.ReadOnly
    ] = AwsError.unwrapOptionField("endOfMeetingReminder", endOfMeetingReminder)
    def getInstantBooking: ZIO[
      Any,
      AwsError,
      zio.aws.alexaforbusiness.model.InstantBooking.ReadOnly
    ] = AwsError.unwrapOptionField("instantBooking", instantBooking)
    def getRequireCheckIn: ZIO[
      Any,
      AwsError,
      zio.aws.alexaforbusiness.model.RequireCheckIn.ReadOnly
    ] = AwsError.unwrapOptionField("requireCheckIn", requireCheckIn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.MeetingRoomConfiguration
  ) extends zio.aws.alexaforbusiness.model.MeetingRoomConfiguration.ReadOnly {
    override val roomUtilizationMetricsEnabled: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.roomUtilizationMetricsEnabled())
        .map(value => value: Boolean)
    override val endOfMeetingReminder: Optional[
      zio.aws.alexaforbusiness.model.EndOfMeetingReminder.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.endOfMeetingReminder())
      .map(value =>
        zio.aws.alexaforbusiness.model.EndOfMeetingReminder.wrap(value)
      )
    override val instantBooking
        : Optional[zio.aws.alexaforbusiness.model.InstantBooking.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instantBooking())
        .map(value => zio.aws.alexaforbusiness.model.InstantBooking.wrap(value))
    override val requireCheckIn
        : Optional[zio.aws.alexaforbusiness.model.RequireCheckIn.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requireCheckIn())
        .map(value => zio.aws.alexaforbusiness.model.RequireCheckIn.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.MeetingRoomConfiguration
  ): zio.aws.alexaforbusiness.model.MeetingRoomConfiguration.ReadOnly =
    new Wrapper(impl)
}
