package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetRoomResponse(
    room: Optional[zio.aws.alexaforbusiness.model.Room] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.GetRoomResponse = {
    import GetRoomResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.GetRoomResponse
      .builder()
      .optionallyWith(room.map(value => value.buildAwsValue()))(_.room)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.GetRoomResponse.ReadOnly =
    zio.aws.alexaforbusiness.model.GetRoomResponse.wrap(buildAwsValue())
}
object GetRoomResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.GetRoomResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.GetRoomResponse =
      zio.aws.alexaforbusiness.model
        .GetRoomResponse(room.map(value => value.asEditable))
    def room: Optional[zio.aws.alexaforbusiness.model.Room.ReadOnly]
    def getRoom
        : ZIO[Any, AwsError, zio.aws.alexaforbusiness.model.Room.ReadOnly] =
      AwsError.unwrapOptionField("room", room)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.GetRoomResponse
  ) extends zio.aws.alexaforbusiness.model.GetRoomResponse.ReadOnly {
    override val room: Optional[zio.aws.alexaforbusiness.model.Room.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.room())
        .map(value => zio.aws.alexaforbusiness.model.Room.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.GetRoomResponse
  ): zio.aws.alexaforbusiness.model.GetRoomResponse.ReadOnly = new Wrapper(impl)
}
