package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetContactResponse(
    contact: Optional[zio.aws.alexaforbusiness.model.Contact] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.GetContactResponse = {
    import GetContactResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.GetContactResponse
      .builder()
      .optionallyWith(contact.map(value => value.buildAwsValue()))(_.contact)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.GetContactResponse.ReadOnly =
    zio.aws.alexaforbusiness.model.GetContactResponse.wrap(buildAwsValue())
}
object GetContactResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.GetContactResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.GetContactResponse =
      zio.aws.alexaforbusiness.model
        .GetContactResponse(contact.map(value => value.asEditable))
    def contact: Optional[zio.aws.alexaforbusiness.model.Contact.ReadOnly]
    def getContact
        : ZIO[Any, AwsError, zio.aws.alexaforbusiness.model.Contact.ReadOnly] =
      AwsError.unwrapOptionField("contact", contact)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.GetContactResponse
  ) extends zio.aws.alexaforbusiness.model.GetContactResponse.ReadOnly {
    override val contact
        : Optional[zio.aws.alexaforbusiness.model.Contact.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contact())
        .map(value => zio.aws.alexaforbusiness.model.Contact.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.GetContactResponse
  ): zio.aws.alexaforbusiness.model.GetContactResponse.ReadOnly = new Wrapper(
    impl
  )
}
