package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.Arn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ForgetSmartHomeAppliancesRequest(roomArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.ForgetSmartHomeAppliancesRequest = {
    import ForgetSmartHomeAppliancesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.ForgetSmartHomeAppliancesRequest
      .builder()
      .roomArn(Arn.unwrap(roomArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.ForgetSmartHomeAppliancesRequest.ReadOnly =
    zio.aws.alexaforbusiness.model.ForgetSmartHomeAppliancesRequest
      .wrap(buildAwsValue())
}
object ForgetSmartHomeAppliancesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.ForgetSmartHomeAppliancesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.alexaforbusiness.model.ForgetSmartHomeAppliancesRequest =
      zio.aws.alexaforbusiness.model.ForgetSmartHomeAppliancesRequest(roomArn)
    def roomArn: Arn
    def getRoomArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(roomArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.ForgetSmartHomeAppliancesRequest
  ) extends zio.aws.alexaforbusiness.model.ForgetSmartHomeAppliancesRequest.ReadOnly {
    override val roomArn: Arn =
      zio.aws.alexaforbusiness.model.primitives.Arn(impl.roomArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.ForgetSmartHomeAppliancesRequest
  ): zio.aws.alexaforbusiness.model.ForgetSmartHomeAppliancesRequest.ReadOnly =
    new Wrapper(impl)
}
