package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.Arn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteConferenceProviderRequest(conferenceProviderArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.DeleteConferenceProviderRequest = {
    import DeleteConferenceProviderRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.DeleteConferenceProviderRequest
      .builder()
      .conferenceProviderArn(
        Arn.unwrap(conferenceProviderArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.DeleteConferenceProviderRequest.ReadOnly =
    zio.aws.alexaforbusiness.model.DeleteConferenceProviderRequest
      .wrap(buildAwsValue())
}
object DeleteConferenceProviderRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.DeleteConferenceProviderRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.alexaforbusiness.model.DeleteConferenceProviderRequest =
      zio.aws.alexaforbusiness.model
        .DeleteConferenceProviderRequest(conferenceProviderArn)
    def conferenceProviderArn: Arn
    def getConferenceProviderArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(conferenceProviderArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.DeleteConferenceProviderRequest
  ) extends zio.aws.alexaforbusiness.model.DeleteConferenceProviderRequest.ReadOnly {
    override val conferenceProviderArn: Arn =
      zio.aws.alexaforbusiness.model.primitives
        .Arn(impl.conferenceProviderArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.DeleteConferenceProviderRequest
  ): zio.aws.alexaforbusiness.model.DeleteConferenceProviderRequest.ReadOnly =
    new Wrapper(impl)
}
