package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.Arn
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateRoomResponse(roomArn: Optional[Arn] = Optional.Absent) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.CreateRoomResponse = {
    import CreateRoomResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.CreateRoomResponse
      .builder()
      .optionallyWith(
        roomArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.roomArn)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.CreateRoomResponse.ReadOnly =
    zio.aws.alexaforbusiness.model.CreateRoomResponse.wrap(buildAwsValue())
}
object CreateRoomResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.CreateRoomResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.CreateRoomResponse =
      zio.aws.alexaforbusiness.model
        .CreateRoomResponse(roomArn.map(value => value))
    def roomArn: Optional[Arn]
    def getRoomArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("roomArn", roomArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.CreateRoomResponse
  ) extends zio.aws.alexaforbusiness.model.CreateRoomResponse.ReadOnly {
    override val roomArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.roomArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.CreateRoomResponse
  ): zio.aws.alexaforbusiness.model.CreateRoomResponse.ReadOnly = new Wrapper(
    impl
  )
}
