package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.Arn
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateBusinessReportScheduleResponse(
    scheduleArn: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.CreateBusinessReportScheduleResponse = {
    import CreateBusinessReportScheduleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.CreateBusinessReportScheduleResponse
      .builder()
      .optionallyWith(
        scheduleArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.scheduleArn)
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.CreateBusinessReportScheduleResponse.ReadOnly =
    zio.aws.alexaforbusiness.model.CreateBusinessReportScheduleResponse
      .wrap(buildAwsValue())
}
object CreateBusinessReportScheduleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.CreateBusinessReportScheduleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.alexaforbusiness.model.CreateBusinessReportScheduleResponse =
      zio.aws.alexaforbusiness.model
        .CreateBusinessReportScheduleResponse(scheduleArn.map(value => value))
    def scheduleArn: Optional[Arn]
    def getScheduleArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("scheduleArn", scheduleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.CreateBusinessReportScheduleResponse
  ) extends zio.aws.alexaforbusiness.model.CreateBusinessReportScheduleResponse.ReadOnly {
    override val scheduleArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.scheduleArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.CreateBusinessReportScheduleResponse
  ): zio.aws.alexaforbusiness.model.CreateBusinessReportScheduleResponse.ReadOnly =
    new Wrapper(impl)
}
