package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.Arn
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateNetworkProfileResponse(
    networkProfileArn: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.CreateNetworkProfileResponse = {
    import CreateNetworkProfileResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.CreateNetworkProfileResponse
      .builder()
      .optionallyWith(
        networkProfileArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.networkProfileArn)
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.CreateNetworkProfileResponse.ReadOnly =
    zio.aws.alexaforbusiness.model.CreateNetworkProfileResponse
      .wrap(buildAwsValue())
}
object CreateNetworkProfileResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.CreateNetworkProfileResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.alexaforbusiness.model.CreateNetworkProfileResponse =
      zio.aws.alexaforbusiness.model
        .CreateNetworkProfileResponse(networkProfileArn.map(value => value))
    def networkProfileArn: Optional[Arn]
    def getNetworkProfileArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("networkProfileArn", networkProfileArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.CreateNetworkProfileResponse
  ) extends zio.aws.alexaforbusiness.model.CreateNetworkProfileResponse.ReadOnly {
    override val networkProfileArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.networkProfileArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.CreateNetworkProfileResponse
  ): zio.aws.alexaforbusiness.model.CreateNetworkProfileResponse.ReadOnly =
    new Wrapper(impl)
}
