package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.{
  CustomerS3BucketName,
  BusinessReportS3Path
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BusinessReportS3Location(
    path: Optional[BusinessReportS3Path] = Optional.Absent,
    bucketName: Optional[CustomerS3BucketName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportS3Location = {
    import BusinessReportS3Location.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportS3Location
      .builder()
      .optionallyWith(
        path.map(value => BusinessReportS3Path.unwrap(value): java.lang.String)
      )(_.path)
      .optionallyWith(
        bucketName.map(value =>
          CustomerS3BucketName.unwrap(value): java.lang.String
        )
      )(_.bucketName)
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.BusinessReportS3Location.ReadOnly =
    zio.aws.alexaforbusiness.model.BusinessReportS3Location
      .wrap(buildAwsValue())
}
object BusinessReportS3Location {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportS3Location
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.BusinessReportS3Location =
      zio.aws.alexaforbusiness.model.BusinessReportS3Location(
        path.map(value => value),
        bucketName.map(value => value)
      )
    def path: Optional[BusinessReportS3Path]
    def bucketName: Optional[CustomerS3BucketName]
    def getPath: ZIO[Any, AwsError, BusinessReportS3Path] =
      AwsError.unwrapOptionField("path", path)
    def getBucketName: ZIO[Any, AwsError, CustomerS3BucketName] =
      AwsError.unwrapOptionField("bucketName", bucketName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportS3Location
  ) extends zio.aws.alexaforbusiness.model.BusinessReportS3Location.ReadOnly {
    override val path: Optional[BusinessReportS3Path] = zio.aws.core.internal
      .optionalFromNullable(impl.path())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.BusinessReportS3Path(value)
      )
    override val bucketName: Optional[CustomerS3BucketName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bucketName())
        .map(value =>
          zio.aws.alexaforbusiness.model.primitives.CustomerS3BucketName(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportS3Location
  ): zio.aws.alexaforbusiness.model.BusinessReportS3Location.ReadOnly =
    new Wrapper(impl)
}
