package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.Arn
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SendInvitationRequest(
    userArn: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.SendInvitationRequest = {
    import SendInvitationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.SendInvitationRequest
      .builder()
      .optionallyWith(
        userArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.userArn)
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.SendInvitationRequest.ReadOnly =
    zio.aws.alexaforbusiness.model.SendInvitationRequest.wrap(buildAwsValue())
}
object SendInvitationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.SendInvitationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.SendInvitationRequest =
      zio.aws.alexaforbusiness.model
        .SendInvitationRequest(userArn.map(value => value))
    def userArn: Optional[Arn]
    def getUserArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("userArn", userArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.SendInvitationRequest
  ) extends zio.aws.alexaforbusiness.model.SendInvitationRequest.ReadOnly {
    override val userArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.userArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.SendInvitationRequest
  ): zio.aws.alexaforbusiness.model.SendInvitationRequest.ReadOnly =
    new Wrapper(impl)
}
